/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.internal.dsl.model.ComponentModelReader;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModulesModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.TestConnectionGlobalElementModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.XmlExtensionModelProperty;
import org.mule.runtime.config.internal.util.NoOpXmlErrorHandler;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.xml.declaration.DeclarationOperation;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.w3c.dom.Document;

public final class XmlExtensionLoaderDelegate {
    public static final String CYCLIC_OPERATIONS_ERROR = "Cyclic operations detected, offending ones: [%s]";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_DEFAULT_VALUE = "defaultValue";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MODULE_NAME = "name";
    private static final String MODULE_PREFIX_ATTRIBUTE = "prefix";
    private static final String MODULE_NAMESPACE_ATTRIBUTE = "namespace";
    private static final String MODULE_NAMESPACE_NAME = "module";
    protected static final String CONFIG_NAME = "config";
    private static final Map<String, ParameterRole> parameterRoleTypes = ImmutableMap.builder().put((Object)"BEHAVIOUR", (Object)ParameterRole.BEHAVIOUR).put((Object)"CONTENT", (Object)ParameterRole.CONTENT).put((Object)"PRIMARY", (Object)ParameterRole.PRIMARY_CONTENT).build();
    private static final String CATEGORY = "category";
    private static final String VENDOR = "vendor";
    private static final String DOC_DESCRIPTION = "doc:description";
    private static final String PASSWORD = "password";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String TAB_ATTRIBUTE = "tab";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String SUMMARY_ATTRIBUTE = "summary";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String ERROR_TYPE_ATTRIBUTE = "type";
    private static final String ROLE = "role";
    private static final String ATTRIBUTE_USE = "use";
    private static final String NAMESPACE_SEPARATOR = ":";
    private static final Pattern VALID_XML_NAME = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");
    private static final String TRANSFORMATION_FOR_TNS_RESOURCE = "META-INF/transform_for_tns.xsl";
    private static final String XMLNS_TNS = "xmlns:tns";
    private static final String MODULE_CONNECTION_MARKER_ATTRIBUTE = "xmlns:connection";
    private static final String GLOBAL_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("operation").build();
    private static final ComponentIdentifier OPERATION_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("property").build();
    private static final ComponentIdentifier CONNECTION_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("connection").build();
    private static final ComponentIdentifier OPERATION_PARAMETERS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameters").build();
    private static final ComponentIdentifier OPERATION_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameter").build();
    private static final ComponentIdentifier OPERATION_BODY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("body").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output-attributes").build();
    private static final ComponentIdentifier OPERATION_ERRORS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("errors").build();
    private static final ComponentIdentifier OPERATION_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("error").build();
    private static final ComponentIdentifier MODULE_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("module").build();
    public static final String XSD_SUFFIX = ".xsd";
    private static final String XML_SUFFIX = ".xml";
    private static final String TYPES_XML_SUFFIX = "-catalog.xml";
    private final String modulePath;
    private final boolean validateXml;
    private final Optional<String> declarationPath;
    private TypeResolver typeResolver;
    private Map<String, DeclarationOperation> declarationMap;

    private static ParameterRole getRole(String role) {
        if (!parameterRoleTypes.containsKey(role)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parametrized role [%s] doesn't match any of the expected types [%s]", role, String.join((CharSequence)", ", parameterRoleTypes.keySet())));
        }
        return parameterRoleTypes.get(role);
    }

    public XmlExtensionLoaderDelegate(String modulePath, boolean validateXml, Optional<String> declarationPath) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)modulePath) ? 1 : 0) != 0, (Object)"modulePath must not be empty");
        this.modulePath = modulePath;
        this.validateXml = validateXml;
        this.declarationPath = declarationPath;
    }

    public void declare(ExtensionLoadingContext context) {
        URL resource = this.getResource(this.modulePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("There's no reachable XML in the path '%s'", this.modulePath));
        }
        try {
            this.loadCustomTypes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The custom type file [%s] for the module '%s' cannot be read properly", this.getCustomTypeFilename(), this.modulePath), e);
        }
        this.loadDeclaration();
        Document moduleDocument = this.getModuleDocument(context, resource);
        this.loadModuleExtension(context.getExtensionDeclarer(), resource, moduleDocument, context.getDslResolvingContext().getExtensions());
    }

    private URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    private void loadCustomTypes() {
        String customTypes = this.getCustomTypeFilename();
        URL resourceCustomType = this.getResource(customTypes);
        this.typeResolver = resourceCustomType != null ? TypeResolver.createFrom((URL)resourceCustomType, (ClassLoader)Thread.currentThread().getContextClassLoader()) : this.getEmptyTypeResolver();
    }

    private TypeResolver getEmptyTypeResolver() {
        return TypeResolver.create((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    private String getCustomTypeFilename() {
        return this.modulePath.replace(XML_SUFFIX, TYPES_XML_SUFFIX);
    }

    private void loadDeclaration() {
        this.declarationMap = new HashMap<String, DeclarationOperation>();
        this.declarationPath.ifPresent(operationsOutputPathValue -> {
            URL operationsOutputResource = this.getResource((String)operationsOutputPathValue);
            if (operationsOutputResource != null) {
                try {
                    this.declarationMap = DeclarationOperation.fromString(IOUtils.toString((URL)operationsOutputResource));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("The declarations file [%s] for the module '%s' cannot be read properly", operationsOutputPathValue, this.modulePath), e);
                }
            }
        });
    }

    private Document getModuleDocument(ExtensionLoadingContext context, URL resource) {
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = this.validateXml ? XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader() : XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader(NoOpXmlErrorHandler::new);
        try {
            HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>(context.getDslResolvingContext().getExtensions());
            this.createTnsExtensionModel(resource, extensions).ifPresent(extensions::add);
            return xmlConfigurationDocumentLoader.loadDocument(extensions, resource.getFile(), resource.openStream());
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an issue reading the stream for the resource %s", resource.getFile())));
        }
    }

    private Optional<ExtensionModel> createTnsExtensionModel(URL resource, Set<ExtensionModel> extensions) throws IOException {
        ExtensionModel result = null;
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        try {
            StreamSource xslt = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(TRANSFORMATION_FOR_TNS_RESOURCE));
            StreamSource moduleToTransform = new StreamSource(resource.openStream());
            TransformerFactory.newInstance().newTransformer(xslt).transform(moduleToTransform, new StreamResult((OutputStream)resultStream));
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an issue transforming the stream for the resource %s while trying to remove the content of the <body> element to generate an XSD", resource.getFile())), (Throwable)e);
        }
        Document transformedModuleDocument = XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader(NoOpXmlErrorHandler::new).loadDocument(extensions, resource.getFile(), (InputStream)new ByteArrayInputStream(resultStream.toByteArray()));
        if (StringUtils.isNotBlank((CharSequence)transformedModuleDocument.getDocumentElement().getAttribute(XMLNS_TNS))) {
            ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
            this.loadModuleExtension(extensionDeclarer, resource, transformedModuleDocument, extensions);
            result = new ExtensionModelFactory().create((ExtensionLoadingContext)new DefaultExtensionLoadingContext(extensionDeclarer, Thread.currentThread().getContextClassLoader(), (DslResolvingContext)new NullDslResolvingContext()));
        }
        return Optional.ofNullable(result);
    }

    private ComponentModel getModuleComponentModel(URL resource, Document moduleDocument) {
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser((ServiceRegistry)new SpiServiceRegistry(), Collections.singletonList(Thread.currentThread().getContextClassLoader()));
        Optional parseModule = xmlApplicationParser.parse(moduleDocument.getDocumentElement());
        if (!parseModule.isPresent()) {
            throw new IllegalArgumentException(String.format("There was an issue trying to read the stream of '%s'", resource.getFile()));
        }
        ComponentModelReader componentModelReader = new ComponentModelReader((ConfigurationPropertiesResolver)new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider()));
        return componentModelReader.extractComponentDefinitionModel((ConfigLine)parseModule.get(), this.modulePath);
    }

    private void loadModuleExtension(ExtensionDeclarer declarer, URL resource, Document moduleDocument, Set<ExtensionModel> extensions) {
        ComponentModel moduleModel = this.getModuleComponentModel(resource, moduleDocument);
        if (!moduleModel.getIdentifier().equals(MODULE_IDENTIFIER)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The root element of a module must be '%s', but found '%s'", MODULE_IDENTIFIER.toString(), moduleModel.getIdentifier().toString())));
        }
        String name = (String)moduleModel.getParameters().get("name");
        String version = "4.0";
        String category = (String)moduleModel.getParameters().get(CATEGORY);
        String vendor = (String)moduleModel.getParameters().get(VENDOR);
        XmlDslModel xmlDslModel = this.getXmlDslModel(moduleModel, name, version);
        String xmlnsTnsValue = (String)moduleModel.getParameters().get(XMLNS_TNS);
        if (xmlnsTnsValue != null && !xmlDslModel.getNamespace().equals(xmlnsTnsValue)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The %s attribute value of the module must be '%s', but found '%s'", XMLNS_TNS, xmlDslModel.getNamespace(), xmlnsTnsValue)));
        }
        DefaultDirectedGraph directedGraph = new DefaultDirectedGraph(DefaultEdge.class);
        declarer.named(name).describedAs(this.getDescription(moduleModel)).fromVendor(vendor).onVersion(version).withCategory(Category.valueOf((String)category.toUpperCase())).withXmlDsl(xmlDslModel);
        declarer.withModelProperty((ModelProperty)this.getXmlExtensionModelProperty(moduleModel, xmlDslModel));
        Optional<ConfigurationDeclarer> configurationDeclarer = this.loadPropertiesFrom(declarer, moduleModel, extensions);
        if (configurationDeclarer.isPresent()) {
            this.loadOperationsFrom((HasOperationDeclarer)configurationDeclarer.get(), moduleModel, (DirectedGraph<String, DefaultEdge>)directedGraph, xmlDslModel);
        } else {
            this.loadOperationsFrom((HasOperationDeclarer)declarer, moduleModel, (DirectedGraph<String, DefaultEdge>)directedGraph, xmlDslModel);
        }
        CycleDetector cycleDetector = new CycleDetector((DirectedGraph)directedGraph);
        Set cycles = cycleDetector.findCycles();
        if (!cycles.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format(CYCLIC_OPERATIONS_ERROR, new TreeSet(cycles))));
        }
    }

    private XmlExtensionModelProperty getXmlExtensionModelProperty(ComponentModel moduleModel, XmlDslModel xmlDslModel) {
        Set namespaceDependencies = MacroExpansionModulesModel.getUsedNamespaces((ComponentModel)moduleModel).stream().filter(namespace -> !xmlDslModel.getNamespace().equals(namespace)).collect(Collectors.toSet());
        return new XmlExtensionModelProperty(namespaceDependencies);
    }

    private XmlDslModel getXmlDslModel(ComponentModel moduleModel, String name, String version) {
        Optional prefix = Optional.ofNullable(moduleModel.getParameters().get(MODULE_PREFIX_ATTRIBUTE));
        Optional namespace = Optional.ofNullable(moduleModel.getParameters().get(MODULE_NAMESPACE_ATTRIBUTE));
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, (String)name, (String)version);
    }

    private String getDescription(ComponentModel componentModel) {
        return componentModel.getParameters().getOrDefault(DOC_DESCRIPTION, "");
    }

    private List<ComponentModel> extractGlobalElementsFrom(ComponentModel moduleModel) {
        HashSet NOT_GLOBAL_ELEMENT_IDENTIFIERS = Sets.newHashSet((Object[])new ComponentIdentifier[]{OPERATION_PROPERTY_IDENTIFIER, CONNECTION_PROPERTIES_IDENTIFIER, OPERATION_IDENTIFIER});
        return moduleModel.getInnerComponents().stream().filter(child -> !NOT_GLOBAL_ELEMENT_IDENTIFIERS.contains(child.getIdentifier())).collect(Collectors.toList());
    }

    private Optional<ConfigurationDeclarer> loadPropertiesFrom(ExtensionDeclarer declarer, ComponentModel moduleModel, Set<ExtensionModel> extensions) {
        List<ComponentModel> globalElementsComponentModel = this.extractGlobalElementsFrom(moduleModel);
        List<ComponentModel> configurationProperties = this.extractProperties(moduleModel);
        List<ComponentModel> connectionProperties = this.extractConnectionProperties(moduleModel);
        this.validateProperties(configurationProperties, connectionProperties);
        if (!(configurationProperties.isEmpty() && connectionProperties.isEmpty() && globalElementsComponentModel.isEmpty())) {
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(CONFIG_NAME);
            configurationDeclarer.withModelProperty((ModelProperty)new GlobalElementComponentModelModelProperty(globalElementsComponentModel));
            configurationProperties.stream().forEach(param -> this.extractProperty((ParameterizedDeclarer)configurationDeclarer, (ComponentModel)param));
            this.addConnectionProvider(configurationDeclarer, connectionProperties, globalElementsComponentModel, extensions);
            return Optional.of(configurationDeclarer);
        }
        return Optional.empty();
    }

    private List<ComponentModel> extractProperties(ComponentModel moduleModel) {
        return moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PROPERTY_IDENTIFIER)).collect(Collectors.toList());
    }

    private List<ComponentModel> extractConnectionProperties(ComponentModel moduleModel) {
        List connectionsComponentModel = moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(CONNECTION_PROPERTIES_IDENTIFIER)).collect(Collectors.toList());
        if (connectionsComponentModel.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There cannot be more than 1 child [%s] element per [%s], found [%d]", CONNECTION_PROPERTIES_IDENTIFIER.getName(), MODULE_IDENTIFIER.getName(), connectionsComponentModel.size())));
        }
        return connectionsComponentModel.isEmpty() ? Collections.EMPTY_LIST : this.extractProperties((ComponentModel)connectionsComponentModel.get(0));
    }

    private void validateProperties(List<ComponentModel> configurationProperties, List<ComponentModel> connectionProperties) {
        List connectionPropertiesNames = connectionProperties.stream().map(ComponentModel::getNameAttribute).collect(Collectors.toList());
        List intersectedProperties = configurationProperties.stream().map(ComponentModel::getNameAttribute).filter(connectionPropertiesNames::contains).collect(Collectors.toList());
        if (!intersectedProperties.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There cannot be properties with the same name even if they are within a <connection>, repeated properties are: [%s]", intersectedProperties.stream().collect(Collectors.joining(", ")))));
        }
    }

    private void addConnectionProvider(ConfigurationDeclarer configurationDeclarer, List<ComponentModel> connectionProperties, List<ComponentModel> globalElementsComponentModel, Set<ExtensionModel> extensions) {
        Optional<ComponentModel> testConnectionGlobalElementOptional = this.getTestConnectionGlobalElement(globalElementsComponentModel, extensions);
        if (testConnectionGlobalElementOptional.isPresent() || !connectionProperties.isEmpty()) {
            ConnectionProviderDeclarer connectionProviderDeclarer = configurationDeclarer.withConnectionProvider("connection");
            connectionProviderDeclarer.withConnectionManagementType(ConnectionManagementType.NONE);
            connectionProperties.stream().forEach(param -> this.extractProperty((ParameterizedDeclarer)connectionProviderDeclarer, (ComponentModel)param));
            testConnectionGlobalElementOptional.ifPresent(testConnectionGlobalElement -> {
                String testConnectionGlobalElementName = (String)testConnectionGlobalElement.getParameters().get("name");
                connectionProviderDeclarer.withModelProperty((ModelProperty)new TestConnectionGlobalElementModelProperty(testConnectionGlobalElementName));
            });
        }
    }

    private Optional<ComponentModel> getTestConnectionGlobalElement(List<ComponentModel> globalElementsComponentModel, Set<ExtensionModel> extensions) {
        List markedAsTestConnectionGlobalElements = globalElementsComponentModel.stream().filter(globalElementComponentModel -> Boolean.parseBoolean((String)globalElementComponentModel.getParameters().get(MODULE_CONNECTION_MARKER_ATTRIBUTE))).collect(Collectors.toList());
        if (markedAsTestConnectionGlobalElements.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("It can only be one global element marked as test connectivity [%s] but found [%d], offended global elements are: [%s]", MODULE_CONNECTION_MARKER_ATTRIBUTE, markedAsTestConnectionGlobalElements.size(), markedAsTestConnectionGlobalElements.stream().map(ComponentModel::getNameAttribute).collect(Collectors.joining(", ")))));
        }
        Optional<ComponentModel> testConnectionGlobalElement = markedAsTestConnectionGlobalElements.stream().findFirst();
        if (!testConnectionGlobalElement.isPresent()) {
            testConnectionGlobalElement = this.findTestConnectionGlobalElementFrom(globalElementsComponentModel, extensions);
        }
        return testConnectionGlobalElement;
    }

    private Optional<ComponentModel> findTestConnectionGlobalElementFrom(List<ComponentModel> globalElementsComponentModel, Set<ExtensionModel> extensions) {
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(extensions);
        HashSet<ComponentModel> testConnectionComponentModels = new HashSet<ComponentModel>();
        for (ComponentModel globalElementComponentModel : globalElementsComponentModel) {
            for (ComponentModel connectionProviderChildElement : globalElementComponentModel.getInnerComponents()) {
                String globalElementConfigurationModelName = globalElementComponentModel.getIdentifier().getName();
                String childConnectionProviderName = connectionProviderChildElement.getIdentifier().getName();
                for (ExtensionModel extensionModel : extensions) {
                    DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)dslResolvingContext);
                    for (ConfigurationModel configurationModel : extensionModel.getConfigurationModels()) {
                        if (!dslSyntaxResolver.resolve((NamedObject)configurationModel).getElementName().equals(globalElementConfigurationModelName)) continue;
                        for (ConnectionProviderModel connectionProviderModel : configurationModel.getConnectionProviders()) {
                            if (!dslSyntaxResolver.resolve((NamedObject)connectionProviderModel).getElementName().equals(childConnectionProviderName)) continue;
                            testConnectionComponentModels.add(globalElementComponentModel);
                        }
                    }
                }
            }
        }
        if (testConnectionComponentModels.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There are [%d] global elements that can be potentially used for test connection when it should be just one. Mark any of them with the attribute [%s=\"true\"], offended global elements are: [%s]", testConnectionComponentModels.size(), MODULE_CONNECTION_MARKER_ATTRIBUTE, testConnectionComponentModels.stream().map(ComponentModel::getNameAttribute).sorted().collect(Collectors.joining(", ")))));
        }
        Optional<ComponentModel> testConnectionGlobalElement = testConnectionComponentModels.stream().findFirst();
        return testConnectionGlobalElement;
    }

    private void loadOperationsFrom(HasOperationDeclarer declarer, ComponentModel moduleModel, DirectedGraph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel) {
        moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_IDENTIFIER)).forEach(operationModel -> this.extractOperationExtension(declarer, (ComponentModel)operationModel, directedGraph, xmlDslModel));
    }

    private void extractOperationExtension(HasOperationDeclarer declarer, ComponentModel operationModel, DirectedGraph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel) {
        String operationName = this.assertValidName(operationModel.getNameAttribute());
        OperationDeclarer operationDeclarer = declarer.withOperation(operationName);
        ComponentModel bodyComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_BODY_IDENTIFIER)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The operation '%s' is missing the <body> statement", operationName)));
        directedGraph.addVertex((Object)operationName);
        this.fillGraphWithTnsReferences(directedGraph, operationName, bodyComponentModel.getInnerComponents());
        operationDeclarer.withModelProperty((ModelProperty)new OperationComponentModelModelProperty(operationModel, bodyComponentModel));
        operationDeclarer.describedAs(this.getDescription(operationModel));
        this.extractOperationParameters(operationDeclarer, operationModel);
        this.extractOutputType(operationDeclarer.withOutput(), OPERATION_OUTPUT_IDENTIFIER, operationModel, this.getDeclarationOutputFor(operationName));
        this.extractOutputType(operationDeclarer.withOutputAttributes(), OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER, operationModel, this.getDeclarationOutputAttributesFor(operationName));
        this.declareErrorModels(operationDeclarer, xmlDslModel, operationName, operationModel);
    }

    private Optional<MetadataType> getDeclarationOutputFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutput());
        }
        return result;
    }

    private Optional<MetadataType> getDeclarationOutputAttributesFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutputAttributes());
        }
        return result;
    }

    private void fillGraphWithTnsReferences(DirectedGraph<String, DefaultEdge> directedGraph, String sourceOperationVertex, List<ComponentModel> innerComponents) {
        innerComponents.forEach(childMPComponentModel -> {
            if ("tns".equals(childMPComponentModel.getIdentifier().getNamespace())) {
                String targetOperationVertex = childMPComponentModel.getIdentifier().getName();
                if (!directedGraph.containsVertex((Object)targetOperationVertex)) {
                    directedGraph.addVertex((Object)targetOperationVertex);
                }
                directedGraph.addEdge((Object)sourceOperationVertex, (Object)targetOperationVertex);
            } else {
                childMPComponentModel.getInnerComponents().forEach(childChildMPComponentModel -> this.fillGraphWithTnsReferences(directedGraph, sourceOperationVertex, childMPComponentModel.getInnerComponents()));
            }
        });
    }

    private String assertValidName(String name) {
        if (!VALID_XML_NAME.matcher(name).matches()) {
            throw new IllegalModelDefinitionException(String.format("The name being used '%s' is not XML valid, it must start with a letter and can be followed by any letter, number or -, _. ", name));
        }
        return name;
    }

    private void extractOperationParameters(OperationDeclarer operationDeclarer, ComponentModel componentModel) {
        Optional<ComponentModel> optionalParametersComponentModel = componentModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETERS_IDENTIFIER)).findAny();
        if (optionalParametersComponentModel.isPresent()) {
            optionalParametersComponentModel.get().getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETER_IDENTIFIER)).forEach(param -> {
                String role = (String)param.getParameters().get(ROLE);
                this.extractParameter((ParameterizedDeclarer)operationDeclarer, (ComponentModel)param, XmlExtensionLoaderDelegate.getRole(role));
            });
        }
    }

    private void extractProperty(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param) {
        this.extractParameter(parameterizedDeclarer, param, ParameterRole.BEHAVIOUR);
    }

    private void extractParameter(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param, ParameterRole role) {
        Map parameters = param.getParameters();
        String receivedInputType = (String)parameters.get("type");
        LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
        if (Boolean.parseBoolean((String)parameters.get(PASSWORD))) {
            layoutModelBuilder.asPassword();
        }
        layoutModelBuilder.order(this.getOrder((String)parameters.get(ORDER_ATTRIBUTE)));
        layoutModelBuilder.tabName(this.getTab((String)parameters.get(TAB_ATTRIBUTE)));
        DisplayModel.DisplayModelBuilder displayModelBuilder = DisplayModel.builder();
        displayModelBuilder.displayName((String)parameters.get(DISPLAY_NAME_ATTRIBUTE));
        displayModelBuilder.summary((String)parameters.get(SUMMARY_ATTRIBUTE));
        displayModelBuilder.example((String)parameters.get(EXAMPLE_ATTRIBUTE));
        MetadataType parameterType = this.extractType(receivedInputType);
        ParameterDeclarer parameterDeclarer = this.getParameterDeclarer(parameterizedDeclarer, parameters);
        parameterDeclarer.describedAs(this.getDescription(param)).withLayout(layoutModelBuilder.build()).withDisplayModel(displayModelBuilder.build()).withRole(role).ofType(parameterType);
    }

    private String getTab(String tab) {
        return StringUtils.isBlank((CharSequence)tab) ? "General" : tab;
    }

    private int getOrder(String order) {
        try {
            return Integer.parseInt(order);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private ParameterDeclarer getParameterDeclarer(ParameterizedDeclarer parameterizedDeclarer, Map<String, String> parameters) {
        String parameterName = this.assertValidName(parameters.get("name"));
        String parameterDefaultValue = parameters.get(PARAMETER_DEFAULT_VALUE);
        UseEnum use = UseEnum.valueOf(parameters.get(ATTRIBUTE_USE));
        if (UseEnum.REQUIRED.equals((Object)use) && StringUtils.isNotBlank((CharSequence)parameterDefaultValue)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] cannot have the %s attribute set to %s when it has a default value", new Object[]{parameterName, ATTRIBUTE_USE, UseEnum.REQUIRED}));
        }
        boolean parameterRequired = UseEnum.REQUIRED.equals((Object)use) || UseEnum.AUTO.equals((Object)use) && StringUtils.isBlank((CharSequence)parameterDefaultValue);
        return parameterRequired ? parameterizedDeclarer.onDefaultParameterGroup().withRequiredParameter(parameterName) : parameterizedDeclarer.onDefaultParameterGroup().withOptionalParameter(parameterName).defaultingTo((Object)parameterDefaultValue);
    }

    private void extractOutputType(OutputDeclarer outputDeclarer, ComponentIdentifier componentIdentifier, ComponentModel operationModel, Optional<MetadataType> calculatedOutput) {
        Optional<ComponentModel> outputAttributesComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(componentIdentifier)).findFirst();
        outputAttributesComponentModel.ifPresent(outputComponentModel -> outputDeclarer.describedAs(this.getDescription((ComponentModel)outputComponentModel)));
        MetadataType metadataType = this.getMetadataType(outputAttributesComponentModel, calculatedOutput);
        outputDeclarer.ofType(metadataType);
    }

    private MetadataType getMetadataType(Optional<ComponentModel> outputAttributesComponentModel, Optional<MetadataType> declarationMetadataType) {
        MetadataType metadataType;
        if (declarationMetadataType.isPresent()) {
            metadataType = declarationMetadataType.get();
        } else if (outputAttributesComponentModel.isPresent()) {
            String receivedOutputAttributeType = (String)outputAttributesComponentModel.get().getParameters().get("type");
            metadataType = this.extractType(receivedOutputAttributeType);
        } else {
            metadataType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build();
        }
        return metadataType;
    }

    private MetadataType extractType(String receivedType) {
        Optional metadataType;
        block3: {
            metadataType = Optional.empty();
            try {
                metadataType = this.typeResolver.resolveType(receivedType);
            }
            catch (TypeResolverException e) {
                if (metadataType.isPresent()) break block3;
                throw new IllegalParameterModelDefinitionException(String.format("The type obtained [%s] cannot be resolved", receivedType), (Throwable)e);
            }
        }
        if (!metadataType.isPresent()) {
            String errorMessage = String.format("should not have reach here. Type obtained [%s] when supported default types are [%s].", receivedType, String.join((CharSequence)", ", PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.keySet()));
            throw new IllegalParameterModelDefinitionException(errorMessage);
        }
        return (MetadataType)metadataType.get();
    }

    private void declareErrorModels(OperationDeclarer operationDeclarer, XmlDslModel xmlDslModel, String operationName, ComponentModel operationModel) {
        Optional<ComponentModel> optionalParametersComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_ERRORS_IDENTIFIER)).findAny();
        optionalParametersComponentModel.ifPresent(componentModel -> componentModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_ERROR_IDENTIFIER)).forEach(param -> {
            String namespace = xmlDslModel.getPrefix().toUpperCase();
            String typeName = (String)param.getParameters().get("type");
            if (StringUtils.isBlank((CharSequence)typeName)) {
                throw new IllegalModelDefinitionException(String.format("The operation [%s] cannot have an <error> with an empty 'type' attribute", operationName));
            }
            if (typeName.contains(NAMESPACE_SEPARATOR)) {
                throw new IllegalModelDefinitionException(String.format("The operation [%s] cannot have an <error> [%s] that contains a reserved character [%s]", operationName, typeName, NAMESPACE_SEPARATOR));
            }
            operationDeclarer.withErrorModel(ErrorModelBuilder.newError((String)typeName, (String)namespace).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build());
        }));
    }

    private static enum UseEnum {
        REQUIRED,
        OPTIONAL,
        AUTO;

    }
}

