/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TestConnectionFailuresTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.exception.expect(MuleRuntimeException.class);
    }

    @Test
    public void multipleGlobalElementsWithXmlnsConnectionAttribute() {
        this.setExpectedMessage("Can't resolve http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd");
        this.getExtensionModelFrom("validation/testconnection/module-multiple-global-element-xmlns-connection-true.xml");
    }

    @Test
    public void multipleGlobalElementsWithTestConnectionAndNotEvenOneDefined() {
        this.setExpectedMessage("first-config-not-defined-to-which-one-do-test-connection", "second-config-not-defined-to-which-one-do-test-connection");
        this.getExtensionModelFrom("validation/testconnection/module-not-defined-test-connection.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getHttpExtension())));
    }

    @Test
    public void multipleGlobalElementsWithTestConnectionAndNotEvenOneDefinedHttpAndFile() {
        this.setExpectedMessage("file-global-element", "http-global-element");
        this.getExtensionModelFrom("validation/testconnection/module-not-defined-test-connection-http-file.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getHttpExtension(), this.getFileExtension())));
    }

    @Test
    public void repeatedPropertiesConfigurationConnection() {
        this.setExpectedMessage("repeated properties are: [someUserConfig, somePassConfig]");
        this.getExtensionModelFrom("validation/testconnection/module-repeated-properties-configuration-connection.xml");
    }

    @Test
    public void multipleConnectionProperties() {
        this.setExpectedMessage("There cannot be more than 1 child [connection] element per [module], found [2]");
        this.getExtensionModelFrom("validation/testconnection/module-multiple-connection.xml");
    }

    private ExtensionModel getFileExtension() {
        return this.mockedExtension("file", "config", "connection");
    }

    private ExtensionModel getHttpExtension() {
        return this.mockedExtension("http", "request-config", "request-connection");
    }

    private void setExpectedMessage(String ... conflictingGlobalElements) {
        this.exception.expectMessage(Arrays.stream(conflictingGlobalElements).collect(Collectors.joining(", ")));
    }

    private ExtensionModel mockedExtension(String name, String config, String connectionProvider) {
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
        extensionDeclarer.named(name).onVersion("4.0.0").fromVendor("MuleSoft testcase").withCategory(Category.COMMUNITY).withConfig(config).withConnectionProvider(connectionProvider).withConnectionManagementType(ConnectionManagementType.NONE);
        return new ExtensionModelFactory().create((ExtensionLoadingContext)new DefaultExtensionLoadingContext(extensionDeclarer, Thread.currentThread().getContextClassLoader(), (DslResolvingContext)new NullDslResolvingContext()));
    }

    private ExtensionModel getExtensionModelFrom(String modulePath) {
        return this.getExtensionModelFrom(modulePath, Collections.emptySet());
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, Set<ExtensionModel> extensions) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resource-xml", modulePath);
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(extensions), parameters);
    }
}

