/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.functional.junit4.matchers.ThatMatcher;
import org.mule.test.functional.AbstractXmlExtensionMuleArtifactFunctionalTestCase;

@Feature(value="Error Handling")
@Story(value="Error Mappings")
public class ModuleUsingErrorMappingTestCase
extends AbstractXmlExtensionMuleArtifactFunctionalTestCase {
    private static final String CONNECT_ERROR_MESSAGE = "Could not connect.";
    private static final String UNMATCHED_ERROR_MESSAGE = "Error.";
    private static final String EXPRESSION_ERROR_MESSAGE = "Bad expression.";
    private static final String TIMEOUT_ERROR_MESSAGE = "Timeout happened!";
    private static final String SECURITY_ERROR_MESSAGE = "simple operation called";

    @Override
    protected String getModulePath() {
        return "modules/module-using-errormapping.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-with-module-using-errormapping.xml";
    }

    @Test
    @Description(value="Verifies that an unmapped error is handled as ANY.")
    public void simpleRequest() throws Exception {
        this.verifySuccessExpression("noMapping", UNMATCHED_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that each error is correctly handled given an operation without mappings.")
    public void multipleMappingsDirectlyFromSmartConnector() throws Exception {
        this.verifyFailingExpression("multipleMappingsDirectlyFromSmartConnector", EXPRESSION_ERROR_MESSAGE);
        this.verifySuccessExpression("multipleMappingsDirectlyFromSmartConnector", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via wildcard is handled.")
    public void mappedRequest() throws Exception {
        this.verifySuccessExpression("simpleMapping", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via a custom matcher is handled. ")
    public void matchingMappedRequest() throws Exception {
        this.verifySuccessExpression("complexMapping", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that an unmapped error is handled as ANY.")
    public void noMatchingMappedRequest() throws Exception {
        this.verifyFailingExpression("complexMapping", UNMATCHED_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that each error is correctly handled given an operation with multiple mappings.")
    public void multipleMappingsRequest() throws Exception {
        this.verifyFailingExpression("multipleMappings", EXPRESSION_ERROR_MESSAGE);
        this.verifySuccessExpression("multipleMappings", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via wildcard is handled through the proxy smart connector.")
    public void mappedRequestProxy() throws Exception {
        this.verifySuccessExpression("simpleMappingProxy", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via a custom matcher is handled through the proxy smart connector.")
    public void matchingMappedRequestProxy() throws Exception {
        this.verifySuccessExpression("complexMappingProxy", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that an unmapped error is handled as ANY through the proxy smart connector.")
    public void noMatchingMappedRequestProxy() throws Exception {
        this.verifyFailingExpression("complexMappingProxy", UNMATCHED_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that each error is correctly handled given an operation with multiple mappings through the proxy smart connector.")
    public void multipleMappingsRequestProxy() throws Exception {
        this.verifyFailingExpression("multipleMappingsProxy", EXPRESSION_ERROR_MESSAGE);
        this.verifySuccessExpression("multipleMappingsProxy", CONNECT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via global error handler works.")
    public void globalMappingWithDefaultErrorHandlerTimeout() throws Exception {
        this.verifySuccessExpression("globalMappingWithDefaultErrorHandlerTimeout", TIMEOUT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via global error handler works, where the on continue holds an operation from a smart connector.")
    public void globalMappingWithDefaultErrorHandlerSecurity() throws Exception {
        this.verifySuccessExpression("globalMappingWithDefaultErrorHandlerSecurity", SECURITY_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via global error handler works using subflows.")
    @Ignore(value="MULE-14351")
    public void globalMappingWithDefaultErrorHandlerTimeoutThruSubflow() throws Exception {
        this.verifySuccessExpression("globalMappingWithDefaultErrorHandlerTimeoutThruSubflow", TIMEOUT_ERROR_MESSAGE);
    }

    @Test
    @Description(value="Verifies that a mapped error via global error handler works using nested subflows.")
    @Ignore(value="MULE-14351")
    public void globalMappingWithDefaultErrorHandlerTimeoutThruSubSubflow() throws Exception {
        this.verifySuccessExpression("globalMappingWithDefaultErrorHandlerTimeoutThruSubSubflow", TIMEOUT_ERROR_MESSAGE);
    }

    private void verifySuccessExpression(String flowName, String expectedPayload) throws Exception {
        this.verify(flowName, expectedPayload, false);
    }

    private void verifyFailingExpression(String flowName, String expectedPayload) throws Exception {
        this.verify(flowName, expectedPayload, true);
    }

    private void verify(String flowName, String expectedPayload, boolean failExpression) throws Exception {
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable("names", Collections.emptyMap())).withVariable("failExpression", (Object)failExpression)).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)ThatMatcher.that((Matcher)Matchers.is((Object)expectedPayload))));
    }
}

