/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.test.functional.AbstractXmlExtensionMuleArtifactFunctionalTestCase;

@Feature(value="Error Handling")
@Story(value="Raise Errors")
public class ModuleUsingRaiseErrorTestCase
extends AbstractXmlExtensionMuleArtifactFunctionalTestCase {
    @Override
    protected String getModulePath() {
        return "modules/module-using-raise-error.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-with-module-using-raise-error.xml";
    }

    @Test
    public void muleStaticErrorRaised() throws Exception {
        this.verifyResultFrom("simple", "Could not connect: A module error occurred.");
    }

    @Test
    public void customStaticErrorRaised() throws Exception {
        this.verifyResultFrom("complex", "Custom error: A custom error occurred.");
    }

    @Test
    public void muleParameterErrorRaised() throws Exception {
        this.verifyResultFrom("simpleProxy", "Could not route: A bad error occurred.");
    }

    @Test
    public void customParameterErrorRaised() throws Exception {
        this.verifyResultFrom("complexProxy", "Custom error: Something went wrong.");
    }

    @Test
    public void muleErrorCanBeMapped() throws Exception {
        this.verifyResultFrom("simpleMapping", "Handled");
    }

    @Test
    public void customErrorCanBeMapped() throws Exception {
        this.verifyResultFrom("complexMapping", "Handled");
    }

    private void verifyResultFrom(String flowName, String expectedPayload) throws Exception {
        Assert.assertThat((Object)this.flowRunner(flowName).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)expectedPayload)));
    }
}

