/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DetectCyclesTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.exception.expect(MuleRuntimeException.class);
    }

    @Test
    public void simpleCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple-cycle.xml", "op1", "op2");
    }

    @Test
    public void simpleCyclesInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple2-cycle.xml", "internal-op1", "internal-op2", "internal-op3");
    }

    @Test
    public void nestedCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-nested-foreach-cycle.xml", "foreach-op1", "foreach-op2");
    }

    @Test
    public void simpleRecursiveCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple-recursive-cycle.xml", "op1");
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, String ... offendingOperations) {
        this.exception.expectMessage(String.format("Cyclic operations detected, offending ones: [%s]", new TreeSet<String>(new HashSet<String>(Arrays.asList(offendingOperations))).toString()));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resource-xml", modulePath);
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), parameters);
    }
}

