/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.internal.util.NameValidationUtil;

public class GlobalElementNamesValidator
implements ExtensionModelValidator {
    public static final String REPEATED_GLOBAL_ELEMENT_NAME_FORMAT_MESSAGE = "Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s";
    public static final String ILLEGAL_GLOBAL_ELEMENT_NAME_FORMAT_MESSAGE = "Global name \"%s\" is ilegal. %s";

    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        HashMap existingObjectsWithName = new HashMap();
        extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).ifPresent(globalElementComponentModelModelProperty -> globalElementComponentModelModelProperty.getGlobalElements().stream().filter(componentModel -> componentModel.getNameAttribute() != null).forEach(componentModel -> {
            String nameAttributeValue = componentModel.getNameAttribute();
            this.validateDuplicatedGlobalElements(extensionModel, (ComponentModel)componentModel, nameAttributeValue, existingObjectsWithName, problemsReporter);
            this.validateNotReservedCharacterInName(extensionModel, nameAttributeValue, problemsReporter);
        }));
    }

    private void validateNotReservedCharacterInName(ExtensionModel extensionModel, String nameAttributeValue, ProblemsReporter problemsReporter) {
        try {
            NameValidationUtil.verifyStringDoesNotContainsReservedCharacters((String)nameAttributeValue);
        }
        catch (IllegalArgumentException e) {
            problemsReporter.addError(new Problem((NamedObject)extensionModel, String.format(ILLEGAL_GLOBAL_ELEMENT_NAME_FORMAT_MESSAGE, nameAttributeValue, StringUtils.isBlank((String)e.getMessage()) ? "" : e.getMessage())));
        }
    }

    private void validateDuplicatedGlobalElements(ExtensionModel extensionModel, ComponentModel componentModel, String nameAttributeValue, Map<String, ComponentModel> existingObjectsWithName, ProblemsReporter problemsReporter) {
        if (existingObjectsWithName.containsKey(nameAttributeValue)) {
            problemsReporter.addError(new Problem((NamedObject)extensionModel, String.format(REPEATED_GLOBAL_ELEMENT_NAME_FORMAT_MESSAGE, nameAttributeValue, existingObjectsWithName.get(nameAttributeValue).getIdentifier(), componentModel.getIdentifier())));
        } else {
            existingObjectsWithName.put(nameAttributeValue, componentModel);
        }
    }
}

