/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Security")
@Story(value="Provide correct XML factories even without isolation")
public class XmlSecureLibrariesVerificationTestCase
extends AbstractMuleTestCase {
    @Test
    public void documentBuilder() {
        DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        Assert.assertThat((Object)factory.getClass().getName(), (Matcher)Matchers.equalTo((Object)"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"));
    }

    @Test
    public void saxParser() {
        SAXParserFactory factory = XMLSecureFactories.createDefault().getSAXParserFactory();
        Assert.assertThat((Object)factory.getClass().getName(), (Matcher)Matchers.equalTo((Object)"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl"));
    }

    @Test
    public void xmlInput() {
        XMLInputFactory factory = XMLSecureFactories.createDefault().getXMLInputFactory();
        Assert.assertThat((Object)factory.getClass().getName(), (Matcher)Matchers.equalTo((Object)"com.sun.xml.internal.stream.XMLInputFactoryImpl"));
    }

    @Test
    public void transformer() {
        TransformerFactory factory = XMLSecureFactories.createDefault().getTransformerFactory();
        Assert.assertThat((Object)factory.getClass().getName(), (Matcher)Matchers.equalTo((Object)"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl"));
    }

    @Test
    public void schema() {
        SchemaFactory factory = XMLSecureFactories.createDefault().getSchemaFactory("http://www.w3.org/2001/XMLSchema");
        Assert.assertThat((Object)factory.getClass().getName(), (Matcher)Matchers.equalTo((Object)"com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory"));
    }
}

