/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.error.Errors;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ModuleGlobalElementTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @Parameterized.Parameter
    public String configFile;
    @Parameterized.Parameter(value=1)
    public String[] paths;

    @Parameterized.Parameters(name="{index}: Running tests for {0} ")
    public static Collection<Object[]> data() {
        return Arrays.asList({"flows/flows-using-module-global-element.xml", new String[]{"modules/module-global-element.xml"}}, {"flows/flows-using-module-global-element-default.xml", new String[]{"modules/module-global-element-default.xml"}}, {"flows/flows-using-module-global-element-default-params.xml", new String[]{"modules/module-global-element-default-params.xml"}});
    }

    @Override
    protected String[] getModulePaths() {
        return this.paths;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testDoGetClient() throws Exception {
        this.assertGetClient("testDoGetClient");
    }

    @Test
    public void testDoGetClientWithPrivateOperation() throws Exception {
        this.assertGetClient("testDoGetClientWithPrivateOperation");
    }

    @Test
    public void testDoGetPets() throws Exception {
        Collection pets = (Collection)((FlowRunner)this.flowRunner("testDoGetPets").withVariable("ownerTest", (Object)"john")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)pets, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"la tota", "la porota"}));
    }

    @Test
    public void testDoGetPetsFailWrongOwnerThrowsException() throws Exception {
        ((FlowRunner)this.flowRunner("testDoGetPets").withVariable("ownerTest", (Object)"notJohn")).runExpectingException(ErrorTypeMatcher.errorType((String)Errors.CORE_NAMESPACE_NAME, (String)"UNKNOWN"));
    }

    private void assertGetClient(String flow) throws Exception {
        PetStoreClient client = (PetStoreClient)this.flowRunner(flow).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)client.getUsername(), (Matcher)CoreMatchers.is((Object)"john"));
        MatcherAssert.assertThat((Object)client.getPassword(), (Matcher)CoreMatchers.is((Object)"notDoe"));
    }
}

