/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.skyscreamer.jsonassert.JSONAssert;

@RunWith(value=Parameterized.class)
public class ModuleExtensionModelJsonTestCase
extends AbstractMuleTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");
    @Parameterized.Parameter
    public ExtensionModel extensionModel;
    @Parameterized.Parameter(value=1)
    public String expectedSource;
    @Parameterized.Parameter(value=2)
    public String extensionName;
    private ExtensionModelJsonSerializer jsonSerializer;
    private String expectedJson;

    @Parameterized.Parameters(name="{2}.json")
    public static Collection<Object[]> data() {
        List<String> extensions = Arrays.asList("module-calling-operations-within-module", "module-capitalized-name", "module-documentation", "module-global-element", "module-global-element-default", "module-json-custom-types", "module-properties", "module-stereotypes", "module-xsd-custom-types");
        Function<String, Object[]> stringFunction = moduleName -> {
            String moduleModelPath = "modules" + File.separator + "model" + File.separator + moduleName + ".json";
            String modulePath = "modules/" + moduleName + ".xml";
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            HashMap<String, CallSite> parameters = new HashMap<String, CallSite>();
            parameters.put("resource-xml", (CallSite)((Object)modulePath));
            ExtensionModel extensionModel = new XmlExtensionModelLoader().loadExtensionModel(contextClassLoader, DslResolvingContext.getDefault(ModuleExtensionModelJsonTestCase.getDependencyExtensions()), parameters);
            return new Object[]{extensionModel, moduleModelPath, extensionModel.getName()};
        };
        return extensions.stream().map(stringFunction).collect(Collectors.toList());
    }

    @Before
    public void setUp() throws IOException {
        this.jsonSerializer = new ExtensionModelJsonSerializer(true);
        this.expectedJson = new String(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.expectedSource).readAllBytes(), StandardCharsets.UTF_8).trim();
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Test
    public void generate() throws Exception {
        String json = this.jsonSerializer.serialize(this.extensionModel).trim();
        try {
            JSONAssert.assertEquals((String)this.expectedJson, (String)json, (boolean)true);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson(json);
            }
            System.out.println(json);
            throw e;
        }
    }

    @Test
    public void load() {
        ExtensionModel result = this.jsonSerializer.deserialize(this.expectedJson);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.extensionModel));
    }

    private void updateExpectedJson(String json) throws URISyntaxException, IOException {
        File root = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(this.expectedSource).toURI()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources/");
        File target = new File(testDir, this.expectedSource);
        Files.writeString(target.toPath(), (CharSequence)json, new OpenOption[0]);
        System.out.println(target.getAbsolutePath() + " was fixed");
    }

    private static Set<ExtensionModel> getDependencyExtensions() {
        ExtensionModel petstore = ModuleExtensionModelJsonTestCase.loadExtension(PetStoreConnector.class, Collections.emptySet());
        ExtensionModel marvel = ModuleExtensionModelJsonTestCase.loadExtension(MarvelExtension.class, Collections.emptySet());
        ExtensionModel ce = MuleExtensionModelProvider.getExtensionModel();
        return new HashSet<ExtensionModel>(Arrays.asList(petstore, marvel, ce));
    }

    private static ExtensionModel loadExtension(Class extension, Set<ExtensionModel> deps) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", extension.getName());
        ctx.put("version", "1.0.0-SNAPSHOT");
        ctx.put("COMPILATION_MODE", true);
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(deps), ctx);
    }
}

