/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.internal.ast.MacroExpansionModuleModel;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Xml SDK")
public class MacroExpansionModuleModelTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-14463120")
    public void ArtifactAstStreamsShouldReturnSameInstances() {
        ComponentAst macroExpandableComponentAst = MacroExpansionModuleModelTestCase.getParameterizedComponent("testComponent", "used-extension");
        MacroExpansionModuleModelTestCase.addComplexParameter(macroExpandableComponentAst, "testComponent", "used-extension", "testComplexParameter", "simpleParameter", "simpleParameterValue");
        ComponentAst macroExpandableFlow = MacroExpansionModuleModelTestCase.getFlowAst("testFlow", macroExpandableComponentAst);
        ExtensionModel macroExpandableExtensionModel = MacroExpansionModuleModelTestCase.getExtensionModel("macroExpandableExtensionModel", "used-extension", Collections.singletonList(macroExpandableFlow));
        ArtifactAst macroExpandedArtifactAst = new MacroExpansionModuleModel((ArtifactAst)Mockito.spy(BaseArtifactAst.class), macroExpandableExtensionModel, Optional.empty()).expand();
        MatcherAssert.assertThat(macroExpandedArtifactAst.recursiveStream().collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])macroExpandedArtifactAst.recursiveStream().toArray()));
    }

    private static ComponentAst addComplexParameter(ComponentAst parameterizedComponent, String parametrizedComponentId, String parametrizedComponentNamespace, String complexParameterName, String simpleParameterName, String simpleParameterValue) {
        ComponentAst complexParameterParameters = (ComponentAst)Mockito.spy(BaseComponentAst.class);
        Mockito.when((Object)complexParameterParameters.getComponentId()).thenReturn(Optional.of(parametrizedComponentId));
        Mockito.when((Object)complexParameterParameters.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace(parametrizedComponentNamespace).name(parametrizedComponentId).build());
        Mockito.when((Object)complexParameterParameters.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        Mockito.when((Object)complexParameterParameters.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)parametrizedComponentId));
        ComponentGenerationInformation complexParameterGenerationInformation = (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class);
        DslElementSyntax complexParameterDslElementSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)complexParameterDslElementSyntax.supportsChildDeclaration()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)complexParameterGenerationInformation.getSyntax()).thenReturn(Optional.of(complexParameterDslElementSyntax));
        Mockito.when((Object)complexParameterParameters.getGenerationInformation()).thenReturn((Object)complexParameterGenerationInformation);
        ComponentParameterAst complexParameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)complexParameter.getGenerationInformation()).thenReturn((Object)complexParameterGenerationInformation);
        ParameterModel complexParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)complexParameterModel.getName()).thenReturn((Object)complexParameterName);
        Mockito.when((Object)complexParameterModel.getType()).thenReturn((Object)MacroExpansionModuleModelTestCase.createObjectType(false, complexParameterName));
        Mockito.when((Object)complexParameter.getModel()).thenReturn((Object)complexParameterModel);
        ComponentParameterAst simpleParameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ParameterModel simpleParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)simpleParameterModel.getName()).thenReturn((Object)simpleParameterName);
        Mockito.when((Object)simpleParameterModel.getType()).thenReturn((Object)new DefaultStringType(MetadataFormat.JSON, new HashMap()));
        Mockito.when((Object)simpleParameter.getModel()).thenReturn((Object)simpleParameterModel);
        Mockito.when((Object)complexParameter.getValue()).thenReturn((Object)Either.right((Object)complexParameterParameters));
        Mockito.when((Object)simpleParameter.getValue()).thenReturn((Object)Either.left((Object)simpleParameterValue));
        Mockito.when((Object)complexParameterParameters.getParameters()).thenReturn(Collections.singletonList(simpleParameter));
        Mockito.when((Object)parameterizedComponent.getParameters()).thenReturn(Collections.singletonList(complexParameter));
        return parameterizedComponent;
    }

    private static ComponentAst getParameterizedComponent(String componentId, String componentNamespace) {
        ComponentAst parametrizedComponentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)parametrizedComponentAst.getComponentId()).thenReturn(Optional.of(componentId));
        Mockito.when((Object)parametrizedComponentAst.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace(componentNamespace).name(componentId).build());
        Mockito.when((Object)parametrizedComponentAst.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)componentId));
        Mockito.when((Object)parametrizedComponentAst.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        return parametrizedComponentAst;
    }

    private static ComponentAst getFlowAst(String flowComponentId, ComponentAst ... directChildren) {
        ComponentAst macroExpandableFlow = (ComponentAst)Mockito.spy(BaseComponentAst.class);
        Mockito.when((Object)macroExpandableFlow.getComponentId()).thenReturn(Optional.of("flow"));
        Mockito.when((Object)macroExpandableFlow.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.FLOW);
        Mockito.when((Object)macroExpandableFlow.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace("mule").name("flow").build());
        Mockito.when((Object)macroExpandableFlow.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        Mockito.when((Object)macroExpandableFlow.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)flowComponentId));
        Mockito.when((Object)macroExpandableFlow.directChildren()).thenReturn(Arrays.asList(directChildren));
        return macroExpandableFlow;
    }

    private static ExtensionModel getExtensionModel(String name, String prefix, List<ComponentAst> globalElements) {
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)extensionModel.getName()).thenReturn((Object)name);
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(prefix).build();
        Mockito.when((Object)extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        GlobalElementComponentModelModelProperty globalElementComponentModelProperty = (GlobalElementComponentModelModelProperty)Mockito.mock(GlobalElementComponentModelModelProperty.class);
        Mockito.when((Object)globalElementComponentModelProperty.getGlobalElements()).thenReturn(globalElements);
        Mockito.when((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class)).thenReturn(Optional.of(globalElementComponentModelProperty));
        return extensionModel;
    }

    private static DefaultObjectType createObjectType(boolean isInstantiable, String className) {
        HashMap<Class, Object> extensions = new HashMap<Class, Object>();
        extensions.put(TypeIdAnnotation.class, new TypeIdAnnotation(className));
        extensions.put(ClassInformationAnnotation.class, new ClassInformationAnnotation(className, false, false, isInstantiable, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        return new DefaultObjectType(Collections.emptySet(), false, null, null, extensions);
    }
}

