/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.internal.factories;

import static org.mule.runtime.core.internal.util.MultiParentClassLoaderUtils.multiParentClassLoaderFor;

import static java.lang.Thread.currentThread;

import static net.bytebuddy.dynamic.loading.ClassLoadingStrategy.Default.CHILD_FIRST;
import static net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy.Default.IMITATE_SUPER_CLASS;

import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;

import java.util.Collection;
import java.util.function.Supplier;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;

/**
 * Just a {@link Supplier} the purpose of which is to add a level of indirection to allow deferring the loading of the ByteBuddy
 * classes until they are really needed.
 */
class XmlSdkConnectionProviderBeanClassSupplier implements Supplier<Class<? extends XmlSdkConnectionProviderWrapper<?>>> {

  private final Collection<ParameterDeclaration> paramDeclarations;

  XmlSdkConnectionProviderBeanClassSupplier(Collection<ParameterDeclaration> paramDeclarations) {
    this.paramDeclarations = paramDeclarations;
  }

  @Override
  public Class<? extends XmlSdkConnectionProviderWrapper<?>> get() {
    DynamicType.Builder connectionProviderWrapperClassBuilder = new ByteBuddy()
        .subclass(XmlSdkConnectionProviderWrapper.class, IMITATE_SUPER_CLASS);

    for (ParameterDeclaration parameterDeclaration : paramDeclarations) {
      connectionProviderWrapperClassBuilder =
          connectionProviderWrapperClassBuilder.defineProperty(parameterDeclaration.getName(), String.class);
    }

    return connectionProviderWrapperClassBuilder.make().load(multiParentClassLoaderFor(currentThread().getContextClassLoader()),
                                                             CHILD_FIRST)
        .getLoaded();
  }
}
