/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ModuleSimpleTestCase
extends AbstractXmlExtensionMuleArtifactFunctionalTestCase {
    @Parameterized.Parameter
    public String configFile;
    @Parameterized.Parameter(value=1)
    public String[] paths;

    @Parameterized.Parameters(name="{index}: Running tests for {0} ")
    public static Collection<Object[]> data() {
        return Arrays.asList({"flows/flows-using-module-simple.xml", new String[]{"modules/module-simple.xml"}}, {"flows/nested/flows-using-module-simple-proxy.xml", new String[]{"modules/module-simple.xml", "modules/nested/module-simple-proxy.xml"}});
    }

    @Override
    protected String[] getModulePaths() {
        return this.paths;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testSetPayloadHardcodedFlow() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlow").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadParamFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadParamFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"new payload"));
    }

    @Test
    public void testSetPayloadParamDefaultFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadParamDefaultFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"15"));
    }

    @Test
    public void testSetPayloadParamDefaultUseOptionalFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadParamDefaultUseOptionalFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"15"));
    }

    @Test
    public void testSetPayloadNoSideEffectFlowVariable() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadNoSideEffectFlowVariable").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"10"));
        MatcherAssert.assertThat((Object)((TypedValue)muleEvent.getVariables().get("testVar")).getValue(), (Matcher)Is.is((Object)"unchanged value"));
    }

    @Test
    public void testDoNothingFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testDoNothingFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"before calling"));
        MatcherAssert.assertThat((Object)((TypedValue)muleEvent.getVariables().get("variableBeforeCalling")).getValue(), (Matcher)Is.is((Object)"value of flowvar before calling"));
    }

    @Test
    public void testSetPayloadParamValueAppender() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadParamValueAppender").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"new payload from module"));
    }

    @Test
    public void testSetPayloadConcatParamsValues() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadConcatParamsValues").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"105"));
    }

    @Test
    public void testSetPayloadUsingUndefinedParam() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadUsingUndefinedParam").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetPayloadHardcodedFlowWithTarget() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowWithTarget").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.nullValue());
        TypedValue targetVariable = (TypedValue)event.getVariables().get("target-variable");
        MatcherAssert.assertThat((Object)targetVariable, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)targetVariable.getValue(), (Matcher)CoreMatchers.instanceOf(Message.class));
        Message targetMessage = (Message)targetVariable.getValue();
        MatcherAssert.assertThat((Object)targetMessage.getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadHardcodedFlowWithTargetOverridingAnExistingVariable() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowWithTargetOverridingAnExistingVariable").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.nullValue());
        TypedValue targetVariable = (TypedValue)event.getVariables().get("existing-variable");
        MatcherAssert.assertThat((Object)targetVariable, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)targetVariable.getValue(), (Matcher)CoreMatchers.instanceOf(Message.class));
        Message targetMessage = (Message)targetVariable.getValue();
        MatcherAssert.assertThat((Object)targetMessage.getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadHardcodedFlowWithTargetAndTargetValuePayload() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowWithTargetAndTargetValuePayload").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.nullValue());
        TypedValue targetVariable = (TypedValue)event.getVariables().get("existing-variable");
        MatcherAssert.assertThat((Object)targetVariable, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)targetVariable.getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        String targetMessage = (String)targetVariable.getValue();
        MatcherAssert.assertThat((Object)targetMessage, (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadUsingOptionalParam() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadUsingOptionalParam").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetPayloadUsingParamValueMoreThanOnceFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadUsingParamValueMoreThanOnceFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"a payload written 2 or more times in the same operation using the same parameter"));
    }

    @Test
    public void testSetPayloadHardcodedFlowThruSubflow() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowThruSubflow").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadHardcodedFlowThruSubSubflow() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowThruSubSubflow").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }

    @Test
    public void testSetPayloadHardcodedFlowThruSubflowWithNestedElements() throws Exception {
        CoreEvent event = this.flowRunner("testSetPayloadHardcodedFlowThruSubflowWithNestedElements").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value"));
    }
}

