/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.extension.api.loader.xml.declaration.DeclarationOperation;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
@Feature(value="Xml SDK")
@Story(value="Declaration override of calculated metadata types")
public class XmlExtensionLoaderWithDeclarationTestCase
extends AbstractMuleTestCase {
    private static final String MODULE_DECLARATION_RESOURCE_FILE = "modules/declaration/module-declarer-datasense.xml";
    private static final MetadataType VOID_TYPE = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build();
    private static final MetadataType STRING_TYPE = (MetadataType)PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.get("string");
    private static final MetadataType NUMBER_TYPE = (MetadataType)PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.get("number");
    private static final MetadataType ANY_TYPE = (MetadataType)PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.get("any");
    private static final MetadataType BOOLEAN_TYPE = (MetadataType)PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.get("boolean");
    private static final String DOC_OUTPUT_FORMAT = "Documentation for the output [%s]";
    private static final String DOC_OUTPUT_ATTRIBUTE_FORMAT = "Documentation for the output-attribute [%s]";
    private final boolean validateXml;

    @Parameterized.Parameters(name="Validate XML: {0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    public XmlExtensionLoaderWithDeclarationTestCase(boolean validateXml) {
        this.validateXml = validateXml;
    }

    @Test
    public void testModuleWithoutDeclaration_expectsNoRemapping() {
        this.assertDefaultModule(Optional.empty());
    }

    @Test
    public void testModuleWrongPathDeclaration_expectsNoRemapping() {
        this.assertDefaultModule(Optional.of("non/existing/folder/non-existing-path-declaration.json"));
    }

    @Test
    public void testModuleWrongOperationsDeclaration_expectsNoRemapping() {
        this.assertDefaultModule(Optional.of("modules/declaration/declaration-no-correct-mapping.json"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testModuleWrongFormatDeclaration_expectsThrowException() {
        this.getExtensionModelFrom(Optional.of("modules/declaration/declaration-no-correct-format.json"));
    }

    @Test
    public void testModuleSingleOperationRemapping_expectsOneRemappedOperation() {
        DeclarationOperation declaresOutput = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).binaryType().build(), (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).numberType().build());
        DeclarationOperation declaresAttributes = new DeclarationOperation(VOID_TYPE, NUMBER_TYPE);
        DeclarationOperation declaresOutputAndAttributes = new DeclarationOperation(ANY_TYPE, BOOLEAN_TYPE);
        DeclarationOperation declaresNothing = new DeclarationOperation(VOID_TYPE, VOID_TYPE);
        this.assertModule(Optional.of("modules/declaration/declaration-one-operation.json"), declaresOutput, declaresAttributes, declaresOutputAndAttributes, declaresNothing);
    }

    @Test
    public void testModuleDoubleOperationRemapping_expectsTwoRemappedOperation() {
        DeclarationOperation declaresOutput = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).binaryType().build(), (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).numberType().build());
        DeclarationOperation declaresAttributes = new DeclarationOperation(VOID_TYPE, NUMBER_TYPE);
        DeclarationOperation declaresOutputAndAttributes = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).numberType().build(), VOID_TYPE);
        DeclarationOperation declaresNothing = new DeclarationOperation(VOID_TYPE, VOID_TYPE);
        this.assertModule(Optional.of("modules/declaration/declaration-two-operations.json"), declaresOutput, declaresAttributes, declaresOutputAndAttributes, declaresNothing);
    }

    @Test
    public void testModuleAllOperationRemapping_expectsAllRemappedOperation() {
        DeclarationOperation declaresOutput = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).binaryType().build(), (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).numberType().build());
        DeclarationOperation declaresAttributes = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).dateType().build(), (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.CSV).numberType().build());
        DeclarationOperation declaresOutputAndAttributes = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).numberType().build(), VOID_TYPE);
        DeclarationOperation declaresNothing = new DeclarationOperation((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).stringType().build(), (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.CSV).stringType().build());
        this.assertModule(Optional.of("modules/declaration/declaration-all-operations.json"), declaresOutput, declaresAttributes, declaresOutputAndAttributes, declaresNothing);
    }

    private void assertDefaultModule(Optional<String> declarationPath) {
        DeclarationOperation declaresOutput = new DeclarationOperation(STRING_TYPE, VOID_TYPE);
        DeclarationOperation declaresAttributes = new DeclarationOperation(VOID_TYPE, NUMBER_TYPE);
        DeclarationOperation declaresOutputAndAttributes = new DeclarationOperation(ANY_TYPE, BOOLEAN_TYPE);
        DeclarationOperation declaresNothing = new DeclarationOperation(VOID_TYPE, VOID_TYPE);
        this.assertModule(declarationPath, declaresOutput, declaresAttributes, declaresOutputAndAttributes, declaresNothing);
    }

    private void assertModule(Optional<String> declarationPath, DeclarationOperation declaresOutput, DeclarationOperation declaresAttributes, DeclarationOperation declaresOutputAndAttributes, DeclarationOperation declaresNothing) {
        ExtensionModel extensionModel = this.getExtensionModelFrom(declarationPath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-declarer-datasense"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)4));
        this.assertOperation("op-declares-output", extensionModel, declaresOutput, String.format(DOC_OUTPUT_FORMAT, "op-declares-output"), "");
        this.assertOperation("op-declares-attributes", extensionModel, declaresAttributes, "", String.format(DOC_OUTPUT_ATTRIBUTE_FORMAT, "op-declares-attributes"));
        this.assertOperation("op-declares-output-and-attributes", extensionModel, declaresOutputAndAttributes, String.format(DOC_OUTPUT_FORMAT, "op-declares-output-and-attributes"), String.format(DOC_OUTPUT_ATTRIBUTE_FORMAT, "op-declares-output-and-attributes"));
        this.assertOperation("op-declares-nothing", extensionModel, declaresNothing, "", "");
    }

    private void assertOperation(String operationName, ExtensionModel extensionModel, DeclarationOperation declarer, String outputDocumentation, String outputAttributeDocumentation) {
        Optional operationModelOptional = extensionModel.getOperationModel(operationName);
        MatcherAssert.assertThat((Object)operationModelOptional.isPresent(), (Matcher)Matchers.is((Object)true));
        OperationModel operationModel = (OperationModel)operationModelOptional.get();
        MatcherAssert.assertThat((Object)operationModel.getOutput().getType(), (Matcher)Matchers.is((Object)declarer.getOutput()));
        MatcherAssert.assertThat((Object)operationModel.getOutput().getDescription(), (Matcher)Matchers.is((Object)outputDocumentation));
        MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getType(), (Matcher)Matchers.is((Object)declarer.getOutputAttributes()));
        MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getDescription(), (Matcher)Matchers.is((Object)outputAttributeDocumentation));
    }

    private ExtensionModel getExtensionModelFrom(Optional<String> declarationPath) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", MODULE_DECLARATION_RESOURCE_FILE);
        parameters.put("validate-xml", this.validateXml);
        parameters.put("COMPILATION_MODE", true);
        declarationPath.ifPresent(path -> parameters.put("resource-declaration", path));
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault((Set)Collections.EMPTY_SET), parameters);
    }
}

