/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.test.functional.AbstractXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.marvel.drstrange.CustomErrorException;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;

@Feature(value="Error Handling")
@Story(value="Raise Errors")
public class ModuleUsingRaiseErrorTestCase
extends AbstractXmlExtensionMuleArtifactFunctionalTestCase {
    @Override
    protected String getModulePath() {
        return "modules/module-using-raise-error.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-with-module-using-raise-error.xml";
    }

    @Test
    public void muleStaticErrorRaised() throws Exception {
        this.verifyResultFrom("simple", "Could not connect: A module error occurred.");
    }

    @Test
    public void customStaticErrorRaised() throws Exception {
        this.verifyResultFrom("complex", "Custom error: A custom error occurred.");
    }

    @Test
    public void muleParameterErrorRaised() throws Exception {
        this.verifyResultFrom("simpleProxy", "Could not route: A bad error occurred.");
    }

    @Test
    public void customParameterErrorRaised() throws Exception {
        this.verifyResultFrom("complexProxy", "Custom error: Something went wrong.");
    }

    @Test
    public void muleErrorCanBeMapped() throws Exception {
        this.verifyResultFrom("simpleMapping", "Handled");
    }

    @Test
    public void customErrorCanBeMapped() throws Exception {
        this.verifyResultFrom("complexMapping", "Handled");
    }

    @Test
    public void simpleWithNoHandling() throws Exception {
        String flowName = "simpleWithNoHandlingFlow";
        MuleException me = (MuleException)this.flowRunner("simpleWithNoHandlingFlow").runExpectingException();
        this.stopFlowConstruct("simpleWithNoHandlingFlow");
        Assert.assertThat((Object)me.getMessage(), (Matcher)CoreMatchers.is((Object)"A module error occurred."));
        Assert.assertThat(me.getInfo().get("Error type"), (Matcher)CoreMatchers.is((Object)Errors.ComponentIdentifiers.Handleable.CONNECTIVITY.toString()));
        Assert.assertThat(me.getInfo().get("Element XML"), (Matcher)CoreMatchers.is((Object)"<module-using-raise-error:fail-raise-error></module-using-raise-error:fail-raise-error>"));
        Assert.assertThat(me.getInfo().get("Element"), (Matcher)CoreMatchers.is((Object)"simpleWithNoHandlingFlow/processors/0 @ ModuleUsingRaiseErrorTestCase#simpleWithNoHandling:flows/flows-with-module-using-raise-error.xml:85"));
    }

    @Test
    public void simpleWithCustomJavaException() throws Exception {
        String flowName = "simpleWithCustomJavaExceptionFlow";
        MuleException me = (MuleException)((FlowRunner)this.flowRunner("simpleWithCustomJavaExceptionFlow").withVariable("food", null)).runExpectingException();
        this.stopFlowConstruct("simpleWithCustomJavaExceptionFlow");
        Assert.assertThat((Object)me.getMessage(), (Matcher)CoreMatchers.is((Object)"java.lang.NullPointerException."));
        Assert.assertThat(me.getInfo().get("Error type"), (Matcher)CoreMatchers.is((Object)ComponentIdentifier.builder().namespace("Marvel".toUpperCase()).name(DrStrangeErrorTypeDefinition.CUSTOM_ERROR.toString()).build().toString()));
        Assert.assertThat(me.getInfo().get("Element XML"), (Matcher)CoreMatchers.is((Object)"<module-using-raise-error:fail-custom-exception content=\"#[vars.food]\"></module-using-raise-error:fail-custom-exception>"));
        Assert.assertThat(me.getInfo().get("Element"), (Matcher)CoreMatchers.is((Object)"simpleWithCustomJavaExceptionFlow/processors/0 @ ModuleUsingRaiseErrorTestCase#simpleWithCustomJavaException:flows/flows-with-module-using-raise-error.xml:89"));
        Assert.assertThat((Object)me.getCause(), (Matcher)CoreMatchers.instanceOf(CustomErrorException.class));
    }

    private void verifyResultFrom(String flowName, String expectedPayload) throws Exception {
        Assert.assertThat((Object)this.flowRunner(flowName).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)expectedPayload)));
    }
}

