/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProviderFactory;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.petstore.extension.PetStoreConnector;

@SmallTest
public class DefaultModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.exception.expect(IllegalModelDefinitionException.class);
    }

    @Test
    public void repeatedParameterNamesThrowsException() {
        this.exception.expectMessage("repeated-parameter");
        this.getExtensionModelFrom("validation/module-repeated-parameters.xml", this.getDependencyExtensions());
    }

    @Test
    public void repeatedOperationNamesThrowsException() {
        this.exception.expectMessage("repeated-operation");
        this.getExtensionModelFrom("validation/module-repeated-operations.xml", this.getDependencyExtensions());
    }

    @Test
    public void repeatedOperationNamesTnsThrowsException() {
        this.exception.expectMessage("repeated-operation-tns");
        this.getExtensionModelFrom("validation/module-repeated-operations-tns.xml");
    }

    @Test
    public void parameterWithRequiredAndDefaultThrowsException() {
        this.exception.expectMessage("aWrongDefinedParameter");
        this.getExtensionModelFrom("validation/module-parameter-required-default.xml");
    }

    @Test
    public void propertyWithRequiredAndDefaultThrowsException() {
        this.exception.expectMessage("aWrongDefinedProperty");
        this.getExtensionModelFrom("validation/module-property-required-default.xml");
    }

    @Test
    public void wrongNamingForXmlThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"[operation with spaces] is not a valid one"), CoreMatchers.containsString((String)"[parameters with spaces] is not a valid one"), CoreMatchers.containsString((String)"[property with spaces] is not a valid one")}));
        this.getExtensionModelFrom("validation/module-not-xml-valid-names.xml", this.getDependencyExtensions());
    }

    @Test
    public void emptyTypeInRaiseErrorThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)String.format("When using a %s the '%s' must not be null nor empty, offending operation '%s'", CoreDslConstants.RAISE_ERROR_IDENTIFIER.toString(), "type", "fail-raise-error")), CoreMatchers.containsString((String)String.format("When using a %s the '%s' must not be null nor empty, offending operation '%s'", CoreDslConstants.RAISE_ERROR_IDENTIFIER.toString(), "type", "fail-raise-error-nested"))}));
        this.getExtensionModelFrom("validation/module-using-raise-error-empty-type.xml", this.getDependencyExtensions());
    }

    @Test
    public void wrongTypeInRaiseErrorNestedThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)String.format("When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'", CoreDslConstants.RAISE_ERROR_IDENTIFIER.toString(), "type", BeanDefinitionFactory.CORE_ERROR_NS, "MODULE-USING-RAISE-ERROR", "WRONG-PREFIX", "fail-raise-error")), CoreMatchers.containsString((String)String.format("When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'", CoreDslConstants.RAISE_ERROR_IDENTIFIER.toString(), "type", BeanDefinitionFactory.CORE_ERROR_NS, "MODULE-USING-RAISE-ERROR", "WRONG-PREFIX", "fail-raise-error-nested"))}));
        this.getExtensionModelFrom("validation/module-using-raise-error-wrong-type.xml", this.getDependencyExtensions());
    }

    @Test
    public void emptyTargetTypeInErrorMappingThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)String.format("When using a %s the '%s' must not be null nor empty, offending operation '%s'", ApplicationModel.ERROR_MAPPING_IDENTIFIER.toString(), "targetType", "fail-raise-error")), CoreMatchers.containsString((String)String.format("When using a %s the '%s' must not be null nor empty, offending operation '%s'", ApplicationModel.ERROR_MAPPING_IDENTIFIER.toString(), "targetType", "fail-raise-error-nested"))}));
        this.getExtensionModelFrom("validation/module-using-errormapping-empty-targetType.xml", this.getDependencyExtensions());
    }

    @Test
    public void wrongTargetTypeInErrorMappingNestedThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)String.format("When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'", ApplicationModel.ERROR_MAPPING_IDENTIFIER.toString(), "targetType", BeanDefinitionFactory.CORE_ERROR_NS, "MODULE-USING-ERRORMAPPING", "WRONG-PREFIX", "fail-raise-error")), CoreMatchers.containsString((String)String.format("When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'", ApplicationModel.ERROR_MAPPING_IDENTIFIER.toString(), "targetType", BeanDefinitionFactory.CORE_ERROR_NS, "MODULE-USING-ERRORMAPPING", "WRONG-PREFIX", "fail-raise-error-nested"))}));
        this.getExtensionModelFrom("validation/module-using-errormapping-wrong-targetType.xml", this.getDependencyExtensions());
    }

    @Test
    public void wrongGlobalElementNamesThrowsException() {
        this.exception.expectMessage(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)String.format("Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s", "repeated-config-name", "petstore:config", "petstore:config")), CoreMatchers.containsString((String)String.format("Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s", "repeated-config-name", "petstore:config", "heisenberg:config")), CoreMatchers.containsString((String)String.format("Global name \"%s\" is ilegal. %s", "ilegal-petstore-config-name_lal[\\{#a", ""))}));
        this.getExtensionModelFrom("validation/module-repeated-global-elements.xml", this.getDependencyExtensions());
    }

    @Test
    public void forbiddenConfigurationPropertiesThrowsException() {
        this.exception.expectMessage(String.format("Configuration properties is not supported, either use <mule:global-property ../>, ${file::file.txt} or <module:property/> instead. Offending global element '%s'", DefaultConfigurationPropertiesProviderFactory.CONFIGURATION_PROPERTIES.toString()));
        this.getExtensionModelFrom("validation/module-configuration-property-file.xml", this.getDependencyExtensions());
    }

    private ExtensionModel getExtensionModelFrom(String modulePath) {
        return this.getExtensionModelFrom(modulePath, Collections.emptySet());
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, Set<ExtensionModel> extensions) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resource-xml", modulePath);
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(extensions), parameters);
    }

    private Set<ExtensionModel> getDependencyExtensions() {
        ExtensionModel petstore = this.loadExtension(PetStoreConnector.class, Collections.emptySet());
        ExtensionModel heisenberg = this.loadExtension(HeisenbergExtension.class, Collections.emptySet());
        return ImmutableSet.builder().add((Object[])new ExtensionModel[]{petstore, heisenberg, MuleExtensionModelProvider.getExtensionModel()}).build();
    }

    private ExtensionModel loadExtension(Class extension, Set<ExtensionModel> depedencyExtensions) {
        DefaultJavaExtensionModelLoader loader = new DefaultJavaExtensionModelLoader();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", extension.getName());
        ctx.put("version", "1.0.0-SNAPSHOT");
        ctx.put("COMPILATION_MODE", true);
        return loader.loadExtensionModel(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(depedencyExtensions), ctx);
    }
}

