/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.extension.internal.loader.XmlExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class DetectCyclesTestCase
extends AbstractMuleTestCase {
    private final boolean validateXml;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Parameterized.Parameters(name="Detecting cycles validating XML: {0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    public DetectCyclesTestCase(boolean validateXml) {
        this.validateXml = validateXml;
    }

    @Before
    public void setUp() {
        this.exception.expect(MuleRuntimeException.class);
    }

    @Test
    public void simpleCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple-cycle.xml", this.getDependencyExtensions(), "op1", "op2");
    }

    @Test
    public void simpleCyclesInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple2-cycle.xml", this.getDependencyExtensions(), "op1", "op2", "op3");
    }

    @Test
    public void simpleCyclesInOperationsThroughTNSPrivateThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple3-cycle.xml", this.getDependencyExtensions(), "op1", "internal-op2", "internal-op3");
    }

    @Test
    public void nestedCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-nested-foreach-cycle.xml", this.getDependencyExtensions(), "foreach-op1", "foreach-op2");
    }

    @Test
    public void simpleRecursiveCycleInOperationsThroughTNSThrowsException() {
        this.getExtensionModelFrom("validation/cycle/module-simple-recursive-cycle.xml", this.getDependencyExtensions(), "op1");
    }

    private Set<ExtensionModel> getDependencyExtensions() {
        return ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).build();
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, Set<ExtensionModel> extensions, String ... offendingOperations) {
        this.exception.expectMessage(String.format("Cyclic operations detected, offending ones: [%s]", new TreeSet<String>(new HashSet<String>(Arrays.asList(offendingOperations))).toString()));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", modulePath);
        parameters.put("validate-xml", this.validateXml);
        parameters.put("COMPILATION_MODE", true);
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(extensions), parameters);
    }
}

