/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.BaseComponentParameterAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.extension.internal.loader.xml.TlsEnabledComponentUtils;

class MacroExpandedComponentAst
extends BaseComponentAstDecorator {
    private static final String TLS_CONTEXT_CONFIG_PARAMETER_KEY = MacroExpandedComponentAst.getTlsContextConfigParameterKey();
    private final ComponentLocation location;
    private final Set<String> moduleGlobalElementsNames;
    private final String defaultGlobalElementSuffix;
    private final Map<String, Object> literalsParameters;
    private final List<ComponentAst> macroExpandedChildren;
    private final boolean isTlsEnabled;

    private static String getTlsContextConfigParameterKey() {
        return "#[vars." + ((InfrastructureTypeMapping.InfrastructureType)InfrastructureTypeMapping.getMap().get(TlsContextFactory.class)).getName() + "]";
    }

    public MacroExpandedComponentAst(ComponentAst original, ComponentLocation location, Set<String> moduleGlobalElementsNames, String defaultGlobalElementSuffix, List<ComponentAst> macroExpandedChildren) {
        this(original, location, moduleGlobalElementsNames, defaultGlobalElementSuffix, Collections.emptyMap(), macroExpandedChildren);
    }

    public MacroExpandedComponentAst(ComponentAst original, ComponentLocation location, Set<String> moduleGlobalElementsNames, String defaultGlobalElementSuffix, Map<String, Object> literalsParameters, List<ComponentAst> macroExpandedChildren) {
        super(original);
        this.location = location;
        this.moduleGlobalElementsNames = moduleGlobalElementsNames;
        this.defaultGlobalElementSuffix = defaultGlobalElementSuffix;
        this.literalsParameters = literalsParameters;
        this.macroExpandedChildren = macroExpandedChildren;
        this.isTlsEnabled = TlsEnabledComponentUtils.isTlsEnabled(original);
    }

    public Stream<ComponentAst> recursiveStream() {
        return Stream.concat(Stream.concat(Stream.of(this), this.getDecorated().directChildrenStream().flatMap(ComponentAst::recursiveStream)), this.directChildrenStream().flatMap(ComponentAst::recursiveStream));
    }

    public Stream<ComponentAst> directChildrenStream() {
        return this.macroExpandedChildren.stream();
    }

    public ComponentParameterAst getParameter(String groupName, String paramName) {
        ComponentParameterAst parameter = super.getParameter(groupName, paramName);
        return parameter != null ? this.mapIdParam(parameter) : null;
    }

    public Collection<ComponentParameterAst> getParameters() {
        return super.getParameters().stream().map(this::mapIdParam).collect(Collectors.toList());
    }

    private boolean mustExpandTlsContextParameter(ComponentParameterAst parameter) {
        return this.isTlsEnabled && TlsEnabledComponentUtils.isTlsContextFactoryParameter(parameter);
    }

    private ComponentParameterAst mapIdParam(ComponentParameterAst originalParameter) {
        Objects.requireNonNull(originalParameter);
        return new BaseComponentParameterAstDecorator(originalParameter){

            public <T> Either<String, T> getValue() {
                Either originalValue = this.getDecorated().getValue();
                if (MacroExpandedComponentAst.this.mustExpandTlsContextParameter(this.getDecorated()) && MacroExpandedComponentAst.this.literalsParameters.containsKey(TLS_CONTEXT_CONFIG_PARAMETER_KEY)) {
                    return Either.right(MacroExpandedComponentAst.this.literalsParameters.get(TLS_CONTEXT_CONFIG_PARAMETER_KEY));
                }
                if (originalValue.isLeft()) {
                    String expression = "#[" + (String)originalValue.getLeft() + "]";
                    if (MacroExpandedComponentAst.this.literalsParameters.containsKey(expression)) {
                        return Either.right(MacroExpandedComponentAst.this.literalsParameters.get(expression));
                    }
                    return originalValue;
                }
                return originalValue.mapRight(this::mapComponent);
            }

            private <T> Object mapComponent(T rawValue) {
                if (this.mustMacroExpandRawValue(rawValue)) {
                    return this.macroExpandedRawValue((String)rawValue);
                }
                if (this.isAnErrorMappings()) {
                    return this.mapErrorMappings(this.getDecorated());
                }
                if (this.supportsChildDeclaration() && !this.isResolvedByMetadataVisitor(rawValue)) {
                    return this.copyMacroExpandedComponentTreeRecursively();
                }
                return rawValue;
            }

            private <T> boolean mustMacroExpandRawValue(T rawValue) {
                return rawValue instanceof String;
            }

            private boolean isAnErrorMappings() {
                return this.getDecorated().getModel().getName().equals("errorMappings");
            }

            private <T> boolean isResolvedByMetadataVisitor(T rawValue) {
                return rawValue instanceof List || rawValue instanceof Map;
            }

            private boolean supportsChildDeclaration() {
                Optional dslElementSyntax = this.getDecorated().getGenerationInformation().getSyntax();
                return dslElementSyntax.map(DslElementSyntax::supportsChildDeclaration).orElse(false);
            }

            private Object mapErrorMappings(ComponentParameterAst originalParameter) {
                return originalParameter.getValue().mapRight(mappings -> ((List)mappings).stream().map(mapping -> new ErrorMapping(MacroExpandedComponentAst.this.literalsParameters.getOrDefault(mapping.getSource(), mapping.getSource()).toString(), MacroExpandedComponentAst.this.literalsParameters.getOrDefault(mapping.getTarget(), mapping.getTarget()).toString())).collect(Collectors.toList())).getRight();
            }

            private Object copyMacroExpandedComponentTreeRecursively() {
                ComponentAst component = (ComponentAst)this.getDecorated().getValue().getRight();
                MacroExpandedComponentAst macroExpandedComponentAst = new MacroExpandedComponentAst(component, component.getLocation(), MacroExpandedComponentAst.this.moduleGlobalElementsNames, MacroExpandedComponentAst.this.defaultGlobalElementSuffix, MacroExpandedComponentAst.this.literalsParameters, MacroExpandedComponentAst.this.macroExpandedChildren);
                return MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)macroExpandedComponentAst, UnaryOperator.identity());
            }

            public String getRawValue() {
                return this.macroExpandedRawValue(this.getDecorated().getRawValue());
            }

            public String getResolvedRawValue() {
                return this.macroExpandedRawValue(this.getDecorated().getResolvedRawValue());
            }

            private String macroExpandedRawValue(String originalRawValue) {
                if (originalRawValue != null) {
                    if (MacroExpandedComponentAst.this.moduleGlobalElementsNames.contains(originalRawValue)) {
                        return originalRawValue.concat("-").concat(MacroExpandedComponentAst.this.defaultGlobalElementSuffix);
                    }
                    return MacroExpandedComponentAst.this.literalsParameters.getOrDefault(originalRawValue, originalRawValue).toString();
                }
                return null;
            }
        };
    }

    public Optional<String> getComponentId() {
        return super.getComponentId().map(this::mapParamValue);
    }

    private String mapParamValue(String originalValue) {
        if (this.moduleGlobalElementsNames.contains(originalValue)) {
            return originalValue.concat("-").concat(this.defaultGlobalElementSuffix);
        }
        return this.literalsParameters.getOrDefault(originalValue, originalValue).toString();
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return super.toString() + " - macroExpanded";
    }
}

