/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.processor;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.config.dsl.XmlSdkConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.util.context.Context;

public class ModuleOperationMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor,
ErrorMappingsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleOperationMessageProcessor.class);
    private static final String ORIGINAL_EVENT_KEY = "mule.xmlSdk.originalEvent";
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    private FeatureFlaggingService featureFlaggingService;
    private final ExtensionManager extensionManager;
    private final OperationModel operationModel;
    private MessageProcessorChain nestedChain;
    private List<Processor> processors;
    private final List<ParameterModel> allProperties;
    private final Map<String, Pair<Object, MetadataType>> properties;
    private final Optional<ValueResolver<ConfigurationProvider>> configurationProviderResolver;
    private final Map<String, Pair<Object, MetadataType>> parameters;
    private final boolean returnsVoid;
    private final Optional<String> target;
    private final String targetValue;
    private final List<EnrichedErrorMapping> errorMappings;
    private CompiledExpression targetValueExpression;
    private final boolean isDynamicConfigRefEnabled = Boolean.getBoolean("mule.experimental.enableDynamicConfigRef");

    public ModuleOperationMessageProcessor(Map<String, Object> parameters, List<EnrichedErrorMapping> errorMappings, ExtensionManager extensionManager, ExtensionModel extensionModel, OperationModel operationModel) {
        this.extensionManager = extensionManager;
        this.allProperties = this.getAllProperties(extensionModel);
        this.properties = this.parseParameters(this.getProperties(parameters), this.allProperties);
        this.parameters = this.parseParameters(parameters, operationModel.getAllParameterModels());
        this.returnsVoid = MetadataTypeUtils.isVoid((MetadataType)operationModel.getOutput().getType());
        this.target = parameters.containsKey("target") ? Optional.of((String)parameters.remove("target")) : Optional.empty();
        this.targetValue = (String)parameters.remove("targetValue");
        this.errorMappings = errorMappings;
        this.configurationProviderResolver = this.getConfigurationProviderResolver(parameters);
        this.operationModel = operationModel;
    }

    public Map<String, String> getProperties(Map<String, Object> parameters) {
        String configRefParameter = (String)parameters.get("config-ref");
        if (configRefParameter != null && !MuleExtensionUtils.isExpression((Object)configRefParameter)) {
            return this.createPropertiesFromConfigName(configRefParameter);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> createPropertiesFromConfigName(String configName) {
        return this.extensionManager.getConfigurationProvider(configName).filter(cp -> cp instanceof XmlSdkConfigurationProvider).map(cp -> ((XmlSdkConfigurationProvider)((Object)cp)).getParameters()).orElse(Collections.emptyMap());
    }

    private List<ParameterModel> getAllProperties(ExtensionModel extensionModel) {
        ArrayList<ParameterModel> result = new ArrayList<ParameterModel>();
        extensionModel.getConfigurationModel("config").ifPresent(configurationModel -> {
            result.addAll(configurationModel.getAllParameterModels());
            configurationModel.getConnectionProviderModel("connection").ifPresent(connectionProviderModel -> result.addAll(connectionProviderModel.getAllParameterModels()));
        });
        return result;
    }

    private Map<String, Pair<Object, MetadataType>> parseParameters(Map<String, ?> parameters, List<ParameterModel> parameterModels) {
        HashMap<String, Pair<Object, MetadataType>> result = new HashMap<String, Pair<Object, MetadataType>>();
        for (ParameterModel parameterModel : parameterModels) {
            String parameterName = parameterModel.getName();
            if (parameterName.equals("target") || parameterName.equals("targetValue")) continue;
            if (parameters.containsKey(parameterName)) {
                result.put(parameterName, (Pair<Object, MetadataType>)new Pair(this.getXmlParameterValue(parameters, parameterName), (Object)parameterModel.getType()));
                continue;
            }
            if (parameterModel.getDefaultValue() == null || !ParameterRole.PRIMARY_CONTENT.equals((Object)parameterModel.getRole()) && !ParameterRole.CONTENT.equals((Object)parameterModel.getRole())) continue;
            result.put(parameterName, (Pair<Object, MetadataType>)new Pair(parameterModel.getDefaultValue(), (Object)parameterModel.getType()));
        }
        return result;
    }

    private Object getXmlParameterValue(Map<String, ?> parameters, String parameterName) {
        Object xmlValue = parameters.get(parameterName);
        return xmlValue instanceof String ? ((String)xmlValue).trim() : xmlValue;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        String localStrategyCtxKey = "mule.xmlSdk." + this.getLocation().getLocation() + ".reactor.onNextError.localStrategy";
        return Flux.from(publisher).map(this::createEventWithParameters).contextWrite(ctx -> ctx.getOrEmpty((Object)localStrategyCtxKey).map(localErrorStr -> ctx.put((Object)"reactor.onNextError.localStrategy", localErrorStr)).orElse((Context)ctx)).transformDeferred(eventPub -> MessageProcessors.applyWithChildContext((Publisher)eventPub, p -> Flux.from((Publisher)p).doOnNext(this::pushFlowStackEntry).transformDeferred((Function)this.nestedChain).doOnNext(event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop()), Optional.ofNullable(this.getLocation()), (FlowExceptionHandler)this.errorHandler())).contextWrite(ctx -> ctx.getOrEmpty((Object)"reactor.onNextError.localStrategy").map(onNextErrorStr -> ctx.put((Object)localStrategyCtxKey, onNextErrorStr)).orElse((Context)ctx)).map(eventResult -> this.processResult((CoreEvent)this.getInternalParameter(ORIGINAL_EVENT_KEY, (CoreEvent)eventResult), (CoreEvent)eventResult));
    }

    private void pushFlowStackEntry(CoreEvent event) {
        DefaultFlowCallStack flowCallStack = (DefaultFlowCallStack)event.getFlowCallStack();
        flowCallStack.push(this.createFlowStackEntry(flowCallStack.peek()));
    }

    private FlowStackElement createFlowStackEntry(FlowStackElement top) {
        ComponentIdentifier identifier = this.getIdentifier();
        if (identifier.getNamespace() == null || "tns".equals(identifier.getNamespace())) {
            String[] peekedWithNamespace = top.getFlowName().split("\\:");
            String peekedNamespace = peekedWithNamespace[0];
            return new FlowStackElement(peekedNamespace + ":" + identifier.getName(), identifier, null);
        }
        return new FlowStackElement(identifier.getNamespace() + ":" + identifier.getName(), identifier, null);
    }

    private BaseExceptionHandler errorHandler() {
        return new BaseExceptionHandler(){

            protected void onError(Exception exception) {
                MessagingException me = (MessagingException)exception;
                CoreEvent event = me.getEvent();
                EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo((Event)event, (Exception)me, null);
                for (ExceptionContextProvider exceptionContextProvider : ModuleOperationMessageProcessor.this.exceptionContextProviders) {
                    exceptionContextProvider.putContextInfo(me.getExceptionInfo(), notificationInfo, (Component)ModuleOperationMessageProcessor.this);
                }
                ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
                this.handleSubChainException(me, (CoreEvent)ModuleOperationMessageProcessor.this.getInternalParameter(ModuleOperationMessageProcessor.ORIGINAL_EVENT_KEY, event, (EventContext)((BaseEventContext)event.getContext()).getParentContext().get()));
            }

            private void handleSubChainException(MessagingException messagingException, CoreEvent originalRequest) {
                CoreEvent.Builder builder = CoreEvent.builder((EventContext)messagingException.getEvent().getContext(), (CoreEvent)originalRequest).error((Error)messagingException.getEvent().getError().get());
                List<EnrichedErrorMapping> errorMappings = ModuleOperationMessageProcessor.this.getErrorMappings();
                if (!errorMappings.isEmpty()) {
                    Error error = (Error)messagingException.getEvent().getError().get();
                    ErrorType errorType = error.getErrorType();
                    ErrorType resolvedType = errorMappings.stream().filter(m -> m.match(errorType)).findFirst().map(EnrichedErrorMapping::getTarget).orElse(errorType);
                    if (!resolvedType.equals(errorType)) {
                        builder.error(ErrorBuilder.builder((Error)error).errorType(resolvedType).build());
                    }
                }
                messagingException.setProcessedEvent(builder.build());
            }

            public String toString() {
                return ModuleOperationMessageProcessor.class.getSimpleName() + ".errorHandler @ " + ModuleOperationMessageProcessor.this.getLocation().getLocation();
            }
        };
    }

    private String getParameterId(String keyPrefix, CoreEvent event) {
        return this.getParameterId(keyPrefix, event.getContext());
    }

    private String getParameterId(String keyPrefix, EventContext context) {
        return keyPrefix + context.getId();
    }

    private <T> T getInternalParameter(String keyPrefix, CoreEvent event) {
        return (T)((InternalEvent)event).getInternalParameter(this.getParameterId(keyPrefix, event));
    }

    private <T> T getInternalParameter(String keyPrefix, CoreEvent event, EventContext context) {
        return (T)((InternalEvent)event).getInternalParameter(this.getParameterId(keyPrefix, context));
    }

    private CoreEvent processResult(CoreEvent originalEvent, CoreEvent chainEvent) {
        if (!this.returnsVoid) {
            originalEvent = this.createNewEventFromJustMessage(originalEvent, chainEvent);
        }
        if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENABLE_XML_SDK_MDC_RESET)) {
            PrivilegedEvent.builder((CoreEvent)chainEvent).clearLoggingVariables();
        }
        return originalEvent;
    }

    private CoreEvent createNewEventFromJustMessage(CoreEvent request, CoreEvent response) {
        CoreEvent.Builder builder = CoreEvent.builder((CoreEvent)request);
        if (this.target.isPresent()) {
            try (ExpressionManagerSession session = this.expressionManager.openSession(BindingContextUtils.getTargetBindingContext((Message)response.getMessage()));){
                builder.addVariable(this.target.get(), session.evaluate(this.targetValueExpression));
            }
        } else {
            builder.message((Message)InternalMessage.builder((Message)response.getMessage()).build());
        }
        return builder.build();
    }

    private CoreEvent createEventWithParameters(CoreEvent event) {
        InternalEvent.Builder builder = InternalEvent.builder((EventContext)event.getContext());
        builder.message((Message)InternalMessage.builder().nullValue().build());
        Map<String, Pair<Object, MetadataType>> resolvedProperties = this.getResolvedProperties(event);
        TypedValue configRef = (TypedValue)event.getVariables().get("config-ref");
        if (configRef != null) {
            builder.addVariable("config-ref", configRef.getValue());
            if (this.properties.isEmpty()) {
                resolvedProperties = this.parseParameters(this.createPropertiesFromConfigName((String)configRef.getValue()), this.allProperties);
            }
        }
        this.addVariables(event, (CoreEvent.Builder)builder, resolvedProperties);
        this.addVariables(event, (CoreEvent.Builder)builder, this.parameters);
        builder.internalParameters(((InternalEvent)event).getInternalParameters());
        builder.addInternalParameter(this.getParameterId(ORIGINAL_EVENT_KEY, event), (Object)event);
        builder.securityContext(event.getSecurityContext());
        InternalEvent newEvent = builder.build();
        newEvent.setSourcePolicyContext(((InternalEvent)event).getSourcePolicyContext());
        return newEvent;
    }

    private Map<String, Pair<Object, MetadataType>> getResolvedProperties(CoreEvent event) {
        if (this.configurationProviderResolver.isPresent()) {
            ConfigurationProvider cp = this.resolveConfigurationProvider(event);
            this.validateConfigurationProvider(cp);
            if (cp instanceof XmlSdkConfigurationProvider) {
                return this.parseParameters(((XmlSdkConfigurationProvider)cp).getParameters(), this.allProperties);
            }
        }
        return this.properties;
    }

    private Optional<ValueResolver<ConfigurationProvider>> getConfigurationProviderResolver(Map<String, Object> parameters) {
        if (!this.isDynamicConfigRefEnabled) {
            return Optional.empty();
        }
        String configRefParameter = (String)parameters.get("config-ref");
        if (MuleExtensionUtils.isExpression((Object)configRefParameter)) {
            return Optional.of(new ConfigurationProviderValueResolver(configRefParameter));
        }
        return Optional.empty();
    }

    private ConfigurationProvider resolveConfigurationProvider(CoreEvent event) {
        ValueResolvingContext valueResolvingContext = ValueResolvingContext.builder((CoreEvent)event).withExpressionManager(this.expressionManager).build();
        try {
            return (ConfigurationProvider)this.configurationProviderResolver.get().resolve(valueResolvingContext);
        }
        catch (MuleException e) {
            throw new IllegalArgumentException(String.format("Error resolving configuration for component '%s'", this.getLocation().getRootContainerName()), e);
        }
    }

    private void validateConfigurationProvider(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(this.operationModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(this.operationModel.getName()).isPresent()) {
            throw new IllegalArgumentException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), this.operationModel.getName(), configurationProvider.getName()));
        }
    }

    private void addVariables(CoreEvent event, CoreEvent.Builder builder, Map<String, Pair<Object, MetadataType>> unevaluatedMap) {
        unevaluatedMap.entrySet().stream().forEach(entry -> {
            boolean isExpression = this.expressionManager.isExpression(((Pair)entry.getValue()).getFirst().toString());
            if (isExpression) {
                TypedValue<?> evaluatedValue = this.getEvaluatedValue(event, ((Pair)entry.getValue()).getFirst().toString(), (MetadataType)((Pair)entry.getValue()).getSecond());
                builder.addVariable((String)entry.getKey(), evaluatedValue);
            } else {
                builder.addVariable((String)entry.getKey(), ((Pair)entry.getValue()).getFirst());
            }
        });
    }

    private TypedValue<?> getEvaluatedValue(CoreEvent event, String value, MetadataType metadataType) {
        TypedValue evaluatedResult;
        Processor head = (Processor)this.nestedChain.getMessageProcessors().get(0);
        ComponentLocation headLocation = ((Component)head).getLocation();
        if (MetadataFormat.JAVA.equals((Object)metadataType.getMetadataFormat())) {
            evaluatedResult = this.expressionManager.evaluate(value, event, headLocation);
        } else {
            String mediaType = (String)metadataType.getMetadataFormat().getValidMimeTypes().iterator().next();
            DataType expectedOutputType = DataType.builder().type(String.class).mediaType(mediaType).charset(StandardCharsets.UTF_8).build();
            evaluatedResult = this.expressionManager.evaluate(value, expectedOutputType, BindingContextUtils.NULL_BINDING_CONTEXT, event, headLocation, false);
        }
        return evaluatedResult;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public void initialise() throws InitialisationException {
        Optional processingStrategy = MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initializing {} {} with processing strategy {}...", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.getLocation().getLocation(), processingStrategy});
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors((Optional)processingStrategy, this.processors);
        super.initialise();
        if (this.targetValue != null) {
            this.targetValueExpression = ExpressionLanguageUtils.compile((String)this.targetValue, (ExpressionLanguage)this.expressionManager);
        }
        LifecycleUtils.initialiseIfNeeded(this.configurationProviderResolver, (MuleContext)this.muleContext);
    }

    public void dispose() {
        LOGGER.debug("Disposing {} {}...", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        LifecycleUtils.disposeIfNeeded(this.configurationProviderResolver, (Logger)LOGGER);
        super.dispose();
    }

    public void start() throws MuleException {
        LOGGER.debug("Starting {} {}...", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        super.start();
    }

    public void stop() throws MuleException {
        LOGGER.debug("Stopping {} {}...", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        super.stop();
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    public List<EnrichedErrorMapping> getErrorMappings() {
        return this.errorMappings;
    }

    @Inject
    public void setFeatureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }
}

