/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ModuleTestConnectionTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @Parameterized.Parameter
    public String path;

    @Parameterized.Parameters(name="{index}: Running tests for {0} ")
    public static Collection<Object[]> data() {
        return Arrays.asList({"modules/module-test-connection.xml"}, {"modules/module-test-connection-multiple-configs-first.xml"}, {"modules/module-test-connection-multiple-configs-second.xml"});
    }

    @Override
    protected String getModulePath() {
        return this.path;
    }

    protected String getConfigFile() {
        return "flows/flows-test-connection-module.xml";
    }

    @Override
    protected boolean shouldValidateXml() {
        return true;
    }

    @Test
    public void testConnection() throws Exception {
        this.assertConnectionOn("theConfigurationNameFromTheAppThatWontBeMacroExpanded");
        this.assertConnectionOn("anotherConfigurationToShowThereIsNoClashOnMacroExpansion");
    }

    private void assertConnectionOn(String beanName) throws MuleException {
        ConfigurationInstance config = muleContext.getExtensionManager().getConfiguration(beanName, this.testEvent());
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)config.getConnectionProvider().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ConnectionProvider connectionProvider = (ConnectionProvider)config.getConnectionProvider().get();
        Object connect = connectionProvider.connect();
        ConnectionValidationResult connectionValidationResult = connectionProvider.validate(connect);
        Assert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)CoreMatchers.is((Object)true));
        connectionProvider.disconnect(connect);
    }
}

