/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.test.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PetStoreConnector;

@RunWith(value=Parameterized.class)
public class ModuleSchemaGeneratorTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final String EXPECTED_FILES_DIR = "modules/schema/";
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionSchemas.updateExpectedFilesOnError");
    private static final ExtensionModel PET_STORE_EXTENSION_MODEL = MuleExtensionUtils.loadExtension(PetStoreConnector.class);
    private final ExtensionSchemaGenerator extensionSchemaFactory = ServiceLoader.load(ExtensionSchemaGenerator.class).iterator().next();

    @Parameterized.Parameters(name="{index}: Validating xsd for {1}")
    public static Collection<Object[]> data() {
        List<String> extensions = Arrays.asList("module-namespace-custom", "module-param-default-types", "module-param-custom-types", "module-param-role", "module-param-types", "module-properties-default-types", "module-properties-types", "module-single-op-with-property", "module-single-operation", "module-single-operation-camelized", "module-tls-config");
        return extensions.stream().map(moduleName -> {
            String modulePath = EXPECTED_FILES_DIR + moduleName + ".xml";
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("resource-xml", modulePath);
            parameters.put("COMPILATION_MODE", true);
            ExtensionModel extensionModel = new XmlExtensionModelLoader().loadExtensionModel(contextClassLoader, DslResolvingContext.getDefault(ModuleSchemaGeneratorTestCase.getDependencies()), parameters);
            return new Object[]{extensionModel, moduleName + ".xsd"};
        }).collect(Collectors.toList());
    }

    private static Set<ExtensionModel> getDependencies() {
        HashSet<ExtensionModel> dependencies = new HashSet<ExtensionModel>();
        dependencies.add(MuleExtensionModelProvider.getExtensionModel());
        dependencies.add(PET_STORE_EXTENSION_MODEL);
        return dependencies;
    }

    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    protected String getExpectedFilesDir() {
        return EXPECTED_FILES_DIR;
    }

    protected String doGenerate(ExtensionModel extensionUnderTest) {
        return this.extensionSchemaFactory.generate(extensionUnderTest, DslResolvingContext.getDefault(Collections.emptySet()));
    }

    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        ExtensionsTestUtils.compareXML((String)expectedContent, (String)actualContent);
    }
}

