/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.message.Message;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ModulesUsingGraphTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    private static final String MODULES_GRAPH_FOLDER = "modules/graph/module-";
    private static final String SUFFIX_XML_FILE = ".xml";
    @Parameterized.Parameter
    public String permutation;
    @Parameterized.Parameter(value=1)
    public String[] paths;

    @Parameterized.Parameters(name="{index}: Running permutation modules {0} ")
    public static Collection<Object[]> data() {
        return Arrays.asList(ModulesUsingGraphTestCase.getParameters("w", "x", "y", "z", "a", "b", "c"), ModulesUsingGraphTestCase.getParameters("w", "z", "a", "b", "x", "c", "y"));
    }

    private static Object[] getParameters(String ... modules) {
        return new Object[]{StringUtils.join((Object[])modules, (String)"-"), Arrays.asList(modules).stream().map(moduleName -> MODULES_GRAPH_FOLDER + moduleName + SUFFIX_XML_FILE).toArray(String[]::new)};
    }

    @Override
    protected String[] getModulePaths() {
        return this.paths;
    }

    protected String getConfigFile() {
        return "flows/flows-using-graph-modules.xml";
    }

    @Test
    public void testUsingModuleB_Op1() throws Exception {
        this.assertCalls("testUsingModuleB_Op1", "b-op1 a-op1 z-op1");
    }

    @Test
    public void testUsingModuleC_Op1() throws Exception {
        this.assertCalls("testUsingModuleC_Op1", "c-op1 b-op1 a-op1 z-op1");
    }

    @Test
    public void testUsingModuleC_Op2() throws Exception {
        this.assertCalls("testUsingModuleC_Op2", "c-op2 a-op1 z-op1");
    }

    @Test
    public void testUsingModuleC_Op3() throws Exception {
        this.assertCalls("testUsingModuleC_Op3", "c-op3 w-op1 w-internal-op");
    }

    @Test
    public void testUsingModuleX_Op1() throws Exception {
        this.assertCalls("testUsingModuleX_Op1", "x-op1 w-op1 w-internal-op");
    }

    @Test
    public void testUsingModuleY_Op1() throws Exception {
        this.assertCalls("testUsingModuleY_Op1", "y-op1 x-op1 w-op1 w-internal-op");
    }

    @Test
    public void testUsingModuleZ_Op1() throws Exception {
        this.assertCalls("testUsingModuleZ_Op1", "z-op1");
    }

    private void assertCalls(String flow, String expected) throws Exception {
        Message consumedMessage = this.flowRunner(flow).run().getMessage();
        Assert.assertThat((Object)consumedMessage, (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)expected)));
    }
}

