/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.factories;

import io.qameta.allure.Feature;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.internal.factories.XmlSdkConfigurationFactory;
import org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Xml SDK")
public class XmlSdkConnectionProviderFactoryTestCase
extends AbstractMuleTestCase {
    private XmlSdkConfigurationFactory configurationFactory;
    private ParameterDeclaration somePropertyParameterDeclaration;

    @Before
    public void before() {
        this.configurationFactory = new XmlSdkConfigurationFactory(Collections.emptyList());
        this.somePropertyParameterDeclaration = new ParameterDeclaration("someProperty");
    }

    @Test
    public void noConnectionProperties() {
        Class connectionProviderObjectType = new XmlSdkConnectionProviderFactory(this.connectionProviderWithFixedValue(), Collections.emptyList(), Collections.emptyList(), this.configurationFactory).getObjectType();
        Map<String, Method> gettersFrom = this.gettersFrom(connectionProviderObjectType);
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapWithSize.anEmptyMap());
    }

    @Test
    public void propertyParam() {
        Class connectionProviderObjectType = new XmlSdkConnectionProviderFactory(this.connectionProviderWithPropertyValue("someProperty"), Collections.emptyList(), Arrays.asList(this.somePropertyParameterDeclaration), this.configurationFactory).getObjectType();
        Map<String, Method> gettersFrom = this.gettersFrom(connectionProviderObjectType);
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapContaining.hasKey((Object)"getSomeProperty"));
    }

    @Test
    public void propertyParamFromConfig() {
        Class connectionProviderObjectType = new XmlSdkConnectionProviderFactory(this.connectionProviderWithPropertyValue("someProperty"), Arrays.asList(this.somePropertyParameterDeclaration), Collections.emptyList(), this.configurationFactory).getObjectType();
        Map<String, Method> gettersFrom = this.gettersFrom(connectionProviderObjectType);
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapContaining.hasKey((Object)"getSomeProperty"));
    }

    @Test
    public void propertyParamFromConfigColliding() {
        Class connectionProviderObjectType = new XmlSdkConnectionProviderFactory(this.connectionProviderWithPropertyValue("someProperty"), Arrays.asList(this.somePropertyParameterDeclaration), Arrays.asList(this.somePropertyParameterDeclaration), this.configurationFactory).getObjectType();
        Map<String, Method> gettersFrom = this.gettersFrom(connectionProviderObjectType);
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapContaining.hasKey((Object)"getSomeProperty"));
    }

    @Test
    public void complexParam() {
        Class connectionProviderObjectType = new XmlSdkConnectionProviderFactory(this.connectionProviderWithComplexParamWithPropertyValue("someProperty"), Collections.emptyList(), Arrays.asList(this.somePropertyParameterDeclaration), this.configurationFactory).getObjectType();
        Map<String, Method> gettersFrom = this.gettersFrom(connectionProviderObjectType);
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(gettersFrom, (Matcher)IsMapContaining.hasKey((Object)"getSomeProperty"));
    }

    @Test
    public void usedValueFromConfigPropagatedToConnectionProvider() throws Exception {
        XmlSdkConfigurationFactory configFactory = new XmlSdkConfigurationFactory(Arrays.asList(this.somePropertyParameterDeclaration));
        Object config = configFactory.newInstance();
        config.getClass().getDeclaredMethod("setSomeProperty", String.class).invoke(config, "myValue");
        ConnectionProvider connectionProvider = new XmlSdkConnectionProviderFactory(this.connectionProviderWithPropertyValue("someProperty"), Arrays.asList(this.somePropertyParameterDeclaration), Collections.emptyList(), configFactory).newInstance();
        Object somePropertyValueConnection = connectionProvider.getClass().getDeclaredMethod("getSomeProperty", new Class[0]).invoke((Object)connectionProvider, new Object[0]);
        MatcherAssert.assertThat((Object)somePropertyValueConnection, (Matcher)CoreMatchers.is((Object)"myValue"));
        MatcherAssert.assertThat((Object)configFactory.getLastBuilt(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private ComponentAst connectionProviderWithFixedValue() {
        ComponentParameterAst fixedValueParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)fixedValueParam.getRawValue()).thenReturn((Object)"fixedValue");
        ComponentAst innerConnectionProviderComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponent.getParameters()).thenReturn(Collections.singleton(fixedValueParam));
        Mockito.when((Object)innerConnectionProviderComponent.recursiveStream()).thenReturn(Stream.of(innerConnectionProviderComponent));
        return innerConnectionProviderComponent;
    }

    private ComponentAst connectionProviderWithPropertyValue(String propertyName) {
        ComponentParameterAst propertyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)propertyParam.getRawValue()).thenReturn((Object)("#[vars." + propertyName + "]"));
        ComponentAst innerConnectionProviderComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponent.getParameters()).thenReturn(Collections.singleton(propertyParam));
        Mockito.when((Object)innerConnectionProviderComponent.recursiveStream()).thenReturn(Stream.of(innerConnectionProviderComponent));
        return innerConnectionProviderComponent;
    }

    private ComponentAst connectionProviderWithComplexParamWithPropertyValue(String propertyName) {
        ComponentParameterAst propertyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)propertyParam.getRawValue()).thenReturn((Object)("#[vars." + propertyName + "]"));
        ComponentAst innerConnectionProviderComponentObject = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponentObject.getParameters()).thenReturn(Collections.singleton(propertyParam));
        ComponentAst innerConnectionProviderComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponent.recursiveStream()).thenReturn(Stream.concat(Stream.of(innerConnectionProviderComponent), Stream.of(innerConnectionProviderComponentObject)));
        return innerConnectionProviderComponent;
    }

    private Map<String, Method> gettersFrom(Class connectionProviderObjectType) {
        return Stream.of(connectionProviderObjectType.getDeclaredMethods()).filter(m -> m.getName().startsWith("get") && m.getParameters().length == 0).collect(Collectors.toMap(m -> m.getName(), UnaryOperator.identity()));
    }
}

