/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.support.internal.client.HttpRequestOptionsConfigToBuilder;

@Feature(value="HTTP Forward Compatibility")
class HttpRequestOptionsConfigToBuilderTestCase {
    private HttpRequestOptionsBuilder actualBuilder;
    private HttpRequestOptionsConfigToBuilder configurer;

    HttpRequestOptionsConfigToBuilderTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.actualBuilder = HttpRequestOptions.builder();
        this.configurer = new HttpRequestOptionsConfigToBuilder(this.actualBuilder);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void configSendBodyAlways(boolean sendBodyAlways) {
        this.configurer.setSendBodyAlways(sendBodyAlways);
        HttpRequestOptions options = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)options.shouldSendBodyAlways(), (Matcher)Matchers.is((Object)sendBodyAlways));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void configFollowsRedirect(boolean followsRedirect) {
        this.configurer.setFollowsRedirect(followsRedirect);
        HttpRequestOptions options = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)options.isFollowsRedirect(), (Matcher)Matchers.is((Object)followsRedirect));
    }

    @ParameterizedTest
    @ValueSource(ints={10000, 20000, 30000})
    void configResponseTimeout(int responseTimeout) {
        this.configurer.setResponseTimeout(responseTimeout);
        HttpRequestOptions options = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)options.getResponseTimeout(), (Matcher)Matchers.is((Object)responseTimeout));
    }

    @Test
    void configAuthentication() {
        String userName = "user";
        String password = "password";
        boolean isPreemptive = true;
        String domain = "domain";
        String workstation = "workstation";
        this.configurer.setAuthentication(auth -> auth.ntlm(userName, password, isPreemptive, domain, workstation));
        HttpRequestOptions options = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)options.getAuthentication().isPresent(), (Matcher)Matchers.is((Object)true));
        HttpAuthentication auth2 = (HttpAuthentication)options.getAuthentication().get();
        MatcherAssert.assertThat((Object)auth2, (Matcher)Matchers.instanceOf(HttpAuthentication.HttpNtlmAuthentication.class));
        HttpAuthentication.HttpNtlmAuthentication ntlmAuth = (HttpAuthentication.HttpNtlmAuthentication)auth2;
        MatcherAssert.assertThat((Object)ntlmAuth.getUsername(), (Matcher)Matchers.is((Object)userName));
        MatcherAssert.assertThat((Object)ntlmAuth.getPassword(), (Matcher)Matchers.is((Object)password));
        MatcherAssert.assertThat((Object)ntlmAuth.isPreemptive(), (Matcher)Matchers.is((Object)isPreemptive));
        MatcherAssert.assertThat((Object)ntlmAuth.getDomain(), (Matcher)Matchers.is((Object)domain));
        MatcherAssert.assertThat((Object)ntlmAuth.getWorkstation(), (Matcher)Matchers.is((Object)workstation));
    }

    @Test
    void configProxy() {
        String host = "proxy.host";
        int port = 12345;
        String nonProxyHost = "nonProxyHost";
        String username = "user";
        String password = "password";
        boolean isPreemptive = false;
        this.configurer.setProxyConfig(proxyConfig -> proxyConfig.host(host).port(port).nonProxyHosts(nonProxyHost).auth(auth -> auth.basic(username, password, isPreemptive)));
        HttpRequestOptions options = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)options.getProxyConfig().isPresent(), (Matcher)Matchers.is((Object)true));
        ProxyConfig proxyConfig2 = (ProxyConfig)options.getProxyConfig().get();
        MatcherAssert.assertThat((Object)proxyConfig2.getHost(), (Matcher)Matchers.is((Object)host));
        MatcherAssert.assertThat((Object)proxyConfig2.getPort(), (Matcher)Matchers.is((Object)port));
        MatcherAssert.assertThat((Object)proxyConfig2.getNonProxyHosts(), (Matcher)Matchers.is((Object)nonProxyHost));
        MatcherAssert.assertThat((Object)proxyConfig2.getUsername(), (Matcher)Matchers.is((Object)username));
        MatcherAssert.assertThat((Object)proxyConfig2.getPassword(), (Matcher)Matchers.is((Object)password));
    }
}

