/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message;

import io.qameta.allure.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.sdk.api.http.domain.entity.HttpEntity;

@Feature(value="HTTP Forward Compatibility")
class HttpEntityFactoryImplTestCase {
    private HttpEntityFactoryImpl factory;

    HttpEntityFactoryImplTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new HttpEntityFactoryImpl();
    }

    @Test
    void fromByteArray() throws IOException {
        byte[] content = "test content".getBytes();
        HttpEntity entity = this.factory.from(content);
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)content));
    }

    @Test
    void fromString() throws IOException {
        String content = "test content";
        HttpEntity entity = this.factory.from(content, StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)content.getBytes()));
    }

    @Test
    void fromInputStreamWithoutContentLength() throws IOException {
        byte[] contentBytes = "test content".getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contentBytes);
        HttpEntity entity = this.factory.from((InputStream)inputStream);
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)contentBytes));
        MatcherAssert.assertThat((Object)entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void fromInputStreamWithNullContentLength() throws IOException {
        byte[] contentBytes = "test content".getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contentBytes);
        HttpEntity entity = this.factory.from((InputStream)inputStream, null);
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)contentBytes));
        MatcherAssert.assertThat((Object)entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void fromInputStreamWithContentLength() throws IOException {
        byte[] contentBytes = "test content".getBytes();
        Long contentLen = contentBytes.length;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contentBytes);
        HttpEntity entity = this.factory.from((InputStream)inputStream, contentLen);
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)contentBytes));
        MatcherAssert.assertThat((Object)entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)entity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)contentLen));
    }

    @Test
    void emptyEntity() throws IOException {
        HttpEntity entity = this.factory.emptyEntity();
        MatcherAssert.assertThat((Object)entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)entity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)entity.getBytes(), (Matcher)Matchers.is((Object)new byte[0]));
    }
}

