/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.api;

import io.qameta.allure.Feature;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.support.api.HttpServiceApiDelegate;
import org.mule.sdk.api.http.client.ClientCreationException;
import org.mule.sdk.api.http.client.HttpClient;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;
import org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.domain.message.response.HttpResponseBuilder;
import org.mule.sdk.api.http.server.ServerCreationException;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpServiceApiDelegateTestCase {
    @Mock
    private HttpService httpService;
    @Mock
    private HttpClientFactory httpClientFactory;
    @Mock
    private HttpServerFactory httpServerFactory;
    private HttpServiceApiDelegate delegate;

    HttpServiceApiDelegateTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.delegate = new HttpServiceApiDelegate();
        this.delegate.setHttpService(Optional.of(this.httpService));
    }

    @Test
    void clientCreation() throws ClientCreationException {
        Mockito.when((Object)this.httpService.getClientFactory()).thenReturn((Object)this.httpClientFactory);
        Mockito.when((Object)this.httpClientFactory.create((HttpClientConfiguration)ArgumentMatchers.any())).thenReturn((Object)((org.mule.runtime.http.api.client.HttpClient)Mockito.mock(org.mule.runtime.http.api.client.HttpClient.class)));
        HttpClient client = this.delegate.client(config -> config.setName("test-client"));
        MatcherAssert.assertThat((Object)client, (Matcher)Matchers.notNullValue());
        ((HttpService)Mockito.verify((Object)this.httpService)).getClientFactory();
        ((HttpClientFactory)Mockito.verify((Object)this.httpClientFactory)).create((HttpClientConfiguration)ArgumentMatchers.any());
    }

    @Test
    void serverCreation() throws Exception {
        Mockito.when((Object)this.httpService.getServerFactory()).thenReturn((Object)this.httpServerFactory);
        Mockito.when((Object)this.httpServerFactory.create((HttpServerConfiguration)ArgumentMatchers.any())).thenReturn((Object)((HttpServer)Mockito.mock(HttpServer.class)));
        org.mule.sdk.api.http.server.HttpServer server = this.delegate.server(config -> {
            config.setName("test-server");
            config.setHost("localhost");
        });
        MatcherAssert.assertThat((Object)server, (Matcher)Matchers.notNullValue());
        ((HttpService)Mockito.verify((Object)this.httpService)).getServerFactory();
        ((HttpServerFactory)Mockito.verify((Object)this.httpServerFactory)).create((HttpServerConfiguration)ArgumentMatchers.any());
    }

    @Test
    void serverCreationFailure() throws Exception {
        Mockito.when((Object)this.httpService.getServerFactory()).thenReturn((Object)this.httpServerFactory);
        Mockito.when((Object)this.httpServerFactory.create((HttpServerConfiguration)ArgumentMatchers.any())).thenThrow(new Throwable[]{new org.mule.runtime.http.api.server.ServerCreationException("Test error")});
        ServerCreationException exception = (ServerCreationException)Assertions.assertThrows(ServerCreationException.class, () -> this.delegate.server(config -> {
            config.setName("test-server");
            config.setHost("localhost");
        }));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Test error"));
    }

    @Test
    void getResponseBuilder() {
        MatcherAssert.assertThat((Object)this.delegate.responseBuilder(), (Matcher)Matchers.notNullValue());
    }

    @Test
    void getResponseBuilderWithOriginal() {
        HttpResponse original = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)original.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)original.getReasonPhrase()).thenReturn((Object)"OK");
        HttpResponseBuilder builder = this.delegate.responseBuilder(original);
        MatcherAssert.assertThat((Object)builder, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)builder.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)builder.getReasonPhrase(), (Matcher)Matchers.is((Object)"OK"));
    }

    @Test
    void getRequestBuilder() {
        MatcherAssert.assertThat((Object)this.delegate.requestBuilder(), (Matcher)Matchers.notNullValue());
    }

    @Test
    void requestBuilderWithPreserveHeaderCase() {
        HttpRequest req = (HttpRequest)((HttpRequestBuilder)this.delegate.requestBuilder(true).uri("https://example.com").addHeader("CaseSensitive", "HelloWorld")).build();
        MatcherAssert.assertThat((Object)req.getHeaderNames(), (Matcher)Matchers.contains((Matcher)Matchers.is((Object)"CaseSensitive")));
    }

    @Test
    void getEntityFactory() {
        MatcherAssert.assertThat((Object)this.delegate.entityFactory(), (Matcher)Matchers.notNullValue());
    }
}

