/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.runtime.http.support.internal.client.SseSourceConfigImpl;
import org.mule.runtime.http.support.internal.message.HttpResponseBuilderWrapper;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;

@Feature(value="HTTP Forward Compatibility")
class SseSourceConfigImplTestCase {
    private SseSourceConfigImpl configurer;

    SseSourceConfigImplTestCase() {
    }

    @BeforeEach
    void setup() {
        this.configurer = new SseSourceConfigImpl();
    }

    @Test
    void mustProvideResponseOrUrl() {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((SseSourceConfigImpl)this.configurer).build());
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"An HTTP Response or an URL must be provided to build an SseSource"));
    }

    @Test
    void fromResponse() {
        HttpResponse res = (HttpResponse)new HttpResponseBuilderWrapper().addHeader("Content-Type", "text/event-stream").build();
        this.configurer.withResponse(res);
        SseSourceConfig config = this.configurer.build();
        MatcherAssert.assertThat((Object)config.getResponse().getHeaderValue("Content-Type"), (Matcher)Matchers.is((Object)"text/event-stream"));
    }

    @Test
    void fromUrlOnly() {
        this.configurer.withUrl("/sse");
        SseSourceConfig config = this.configurer.build();
        MatcherAssert.assertThat((Object)config.getUrl(), (Matcher)Matchers.is((Object)"/sse"));
    }

    @Test
    void withRetry() {
        this.configurer.withUrl("/sse").withRetry(true).withAllowRetryDelayOverride(false).withInitialRetryDelayMillis(1234L);
        SseSourceConfig config = this.configurer.build();
        SseRetryConfig retryConfig = config.getRetryConfig();
        MatcherAssert.assertThat((Object)retryConfig.shouldRetryOnStreamEnd(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)retryConfig.allowRetryDelayOverride(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)retryConfig.initialRetryDelayMillis(), (Matcher)Matchers.is((Object)1234L));
    }

    @Test
    void withRequestCustomizations() {
        this.configurer.withUrl("/sse").withPreserveHeadersCase(false).withRequestOptions(opts -> opts.setResponseTimeout(1234)).withRequestCustomizer(req -> req.addQueryParam("foo", "bar"));
        SseSourceConfig config = this.configurer.build();
        MatcherAssert.assertThat((Object)config.getRequestOptions().getResponseTimeout(), (Matcher)Matchers.is((Object)1234));
        HttpRequestBuilder someBuilder = HttpRequest.builder().uri("/sse");
        config.getRequestCustomizer().accept(someBuilder);
        MatcherAssert.assertThat((Object)((String)someBuilder.build().getQueryParams().get((Object)"foo")), (Matcher)Matchers.is((Object)"bar"));
    }
}

