/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.runtime.http.support.internal.message.HttpResponseBuilderWrapper;
import org.mule.sdk.api.http.domain.entity.HttpEntity;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;

@Feature(value="HTTP Forward Compatibility")
class HttpResponseBuilderWrapperTestCase {
    private HttpResponseBuilderWrapper builderWrapper;

    HttpResponseBuilderWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.builderWrapper = new HttpResponseBuilderWrapper();
    }

    @Test
    void statusCode() {
        this.builderWrapper.statusCode(Integer.valueOf(207));
        MatcherAssert.assertThat((Object)this.builderWrapper.getStatusCode(), (Matcher)Matchers.is((Object)207));
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)207));
    }

    @Test
    void reasonPhrase() {
        this.builderWrapper.reasonPhrase("Hello");
        MatcherAssert.assertThat((Object)this.builderWrapper.getReasonPhrase(), (Matcher)Matchers.is((Object)"Hello"));
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getReasonPhrase(), (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    void entity() throws IOException {
        HttpEntity entity = new HttpEntityFactoryImpl().from("test content", StandardCharsets.UTF_8);
        this.builderWrapper.entity(entity);
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)"test content".getBytes()));
    }

    @Test
    void addHeader() {
        this.builderWrapper.addHeader("key", "value");
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaderValue("key").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.builderWrapper.getHeaderValue("key").get()), (Matcher)Matchers.is((Object)"value"));
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getHeaderValue("key"), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    void addHeaders() {
        this.builderWrapper.addHeaders("header", Arrays.asList("value1", "value2"));
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaderValues("header"), (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getHeaderValues("header"), (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void removeHeader() {
        this.builderWrapper.addHeader("test-header", "test-value").removeHeader("test-header");
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.containsHeader("test-header"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void headers() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"key1", (Object)"value1");
        this.builderWrapper.headers(headers);
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaders().getAll((Object)"key1"), (Matcher)Matchers.hasItem((Object)"value1"));
        HttpResponse response = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)response.getHeaders().getAll((Object)"key1"), (Matcher)Matchers.hasItem((Object)"value1"));
    }
}

