/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.sdktomule;

import io.qameta.allure.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpEntityWrapper;
import org.mule.sdk.api.http.domain.entity.HttpEntity;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpEntityWrapperTestCase {
    @Mock
    private HttpEntity sdkEntity;
    private HttpEntityWrapper entityWrapper;

    HttpEntityWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.entityWrapper = new HttpEntityWrapper(this.sdkEntity);
    }

    @Test
    void isStreaming() {
        Mockito.when((Object)this.sdkEntity.isStreaming()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.entityWrapper.isStreaming(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void getContent() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("hello".getBytes());
        Mockito.when((Object)this.sdkEntity.getContent()).thenReturn((Object)inputStream);
        MatcherAssert.assertThat((Object)this.entityWrapper.getContent(), (Matcher)Matchers.is((Object)inputStream));
    }

    @Test
    void getBytes() throws IOException {
        byte[] bytes = "hello".getBytes();
        Mockito.when((Object)this.sdkEntity.getBytes()).thenReturn((Object)bytes);
        MatcherAssert.assertThat((Object)this.entityWrapper.getBytes(), (Matcher)Matchers.is((Object)bytes));
    }

    @Test
    void getLength() {
        Mockito.when((Object)this.sdkEntity.getBytesLength()).thenReturn((Object)OptionalLong.of(12L));
        Optional gotLength = this.entityWrapper.getLength();
        MatcherAssert.assertThat((Object)gotLength.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Long)gotLength.get()), (Matcher)Matchers.is((Object)12L));
        Mockito.when((Object)this.sdkEntity.getBytesLength()).thenReturn((Object)OptionalLong.empty());
        MatcherAssert.assertThat((Object)this.entityWrapper.getLength(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    void getBytesLength() {
        Mockito.when((Object)this.sdkEntity.getBytesLength()).thenReturn((Object)OptionalLong.of(12L));
        OptionalLong gotLength = this.entityWrapper.getBytesLength();
        MatcherAssert.assertThat((Object)gotLength.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)gotLength.getAsLong(), (Matcher)Matchers.is((Object)12L));
        Mockito.when((Object)this.sdkEntity.getBytesLength()).thenReturn((Object)OptionalLong.empty());
        MatcherAssert.assertThat((Object)this.entityWrapper.getLength(), (Matcher)Matchers.is(Optional.empty()));
    }
}

