/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.support.internal.server.HttpResponseReadyCallbackWrapper;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.sse.server.SseClient;
import org.mule.sdk.api.http.sse.server.SseClientConfigurer;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpResponseReadyCallbackWrapperTestCase {
    @Mock
    private HttpResponseReadyCallback mockCallback;
    private HttpResponseReadyCallbackWrapper wrapper;

    HttpResponseReadyCallbackWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.wrapper = new HttpResponseReadyCallbackWrapper(this.mockCallback);
    }

    @Test
    void responseReady() {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        org.mule.sdk.api.http.server.async.ResponseStatusCallback statusCallback = (org.mule.sdk.api.http.server.async.ResponseStatusCallback)Mockito.mock(org.mule.sdk.api.http.server.async.ResponseStatusCallback.class);
        this.wrapper.responseReady(response, statusCallback);
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.mockCallback)).responseReady((org.mule.runtime.http.api.domain.message.response.HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any());
    }

    @Test
    void startSseResponse() {
        Consumer configurer = (Consumer)Mockito.mock(Consumer.class);
        SseClient sseClient = this.wrapper.startSseResponse(configurer);
        MatcherAssert.assertThat((Object)sseClient, (Matcher)Matchers.notNullValue());
        ((Consumer)Mockito.verify((Object)configurer)).accept((SseClientConfigurer)ArgumentMatchers.any());
    }
}

