/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.muletosdk;

import io.qameta.allure.Feature;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.support.internal.message.muletosdk.ServerSentEventWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class ServerSentEventWrapperTestCase {
    @Mock
    private ServerSentEvent muleEvent;
    private ServerSentEventWrapper sseWrapper;

    ServerSentEventWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.sseWrapper = new ServerSentEventWrapper(this.muleEvent);
    }

    @Test
    void getName() {
        String name = "test-event";
        Mockito.when((Object)this.muleEvent.getName()).thenReturn((Object)name);
        MatcherAssert.assertThat((Object)this.sseWrapper.getName(), (Matcher)Matchers.is((Object)name));
    }

    @Test
    void getData() {
        String data = "test data";
        Mockito.when((Object)this.muleEvent.getData()).thenReturn((Object)data);
        MatcherAssert.assertThat((Object)this.sseWrapper.getData(), (Matcher)Matchers.is((Object)data));
    }

    @Test
    void getId() {
        String id = "123";
        Mockito.when((Object)this.muleEvent.getId()).thenReturn(Optional.of(id));
        Optional result = this.sseWrapper.getId();
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)result.get()), (Matcher)Matchers.is((Object)id));
    }

    @Test
    void getIdEmpty() {
        Mockito.when((Object)this.muleEvent.getId()).thenReturn(Optional.empty());
        Optional result = this.sseWrapper.getId();
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void getRetryDelay() {
        Long retryDelay = 5000L;
        Mockito.when((Object)this.muleEvent.getRetryDelay()).thenReturn(Optional.of(retryDelay));
        Optional result = this.sseWrapper.getRetryDelay();
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Long)result.get()), (Matcher)Matchers.is((Object)retryDelay));
    }

    @Test
    void getRetryDelayEmpty() {
        Mockito.when((Object)this.muleEvent.getRetryDelay()).thenReturn(Optional.empty());
        Optional result = this.sseWrapper.getRetryDelay();
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

