/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.sdktomule;

import io.qameta.allure.Feature;
import java.net.URI;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpRequestWrapper;
import org.mule.sdk.api.http.domain.HttpProtocolVersion;
import org.mule.sdk.api.http.domain.entity.HttpEntity;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpRequestWrapperTestCase {
    @Mock
    private HttpRequest sdkRequest;
    private HttpRequestWrapper requestWrapper;

    HttpRequestWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.requestWrapper = new HttpRequestWrapper(this.sdkRequest);
    }

    @Test
    void getProtocol() {
        Mockito.when((Object)this.sdkRequest.getProtocolVersion()).thenReturn((Object)HttpProtocolVersion.HTTP_1_1);
        MatcherAssert.assertThat((Object)this.requestWrapper.getProtocol(), (Matcher)Matchers.is((Object)HttpProtocol.HTTP_1_1));
    }

    @Test
    void getPath() {
        Mockito.when((Object)this.sdkRequest.getPath()).thenReturn((Object)"/path");
        MatcherAssert.assertThat((Object)this.requestWrapper.getPath(), (Matcher)Matchers.is((Object)"/path"));
    }

    @Test
    void getMethod() {
        Mockito.when((Object)this.sdkRequest.getMethod()).thenReturn((Object)"GET");
        MatcherAssert.assertThat((Object)this.requestWrapper.getMethod(), (Matcher)Matchers.is((Object)"GET"));
    }

    @Test
    void getUri() {
        Mockito.when((Object)this.sdkRequest.getUri()).thenReturn((Object)URI.create("/path"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getUri().getPath(), (Matcher)Matchers.is((Object)"/path"));
    }

    @Test
    void getQueryParams() {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"param1", (Object)"value1");
        queryParams.put((Object)"param2", (Object)"value2");
        Mockito.when((Object)this.sdkRequest.getQueryParams()).thenReturn((Object)queryParams);
        MatcherAssert.assertThat((Object)this.requestWrapper.getQueryParams(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"param2", (Object)"value2")));
    }

    @Test
    void getEntity() {
        HttpEntity entity = new HttpEntityFactoryImpl().emptyEntity();
        Mockito.when((Object)this.sdkRequest.getEntity()).thenReturn((Object)entity);
        MatcherAssert.assertThat((Object)this.requestWrapper.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.requestWrapper.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    void getHeaderNames() {
        Mockito.when((Object)this.sdkRequest.getHeaderNames()).thenReturn(Arrays.asList("header1", "header2"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderNames(), (Matcher)Matchers.contains((Object[])new String[]{"header1", "header2"}));
    }

    @Test
    void getHeaderValue() {
        Mockito.when((Object)this.sdkRequest.getHeaderValue("header1")).thenReturn((Object)"value1");
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValue("header1"), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValueIgnoreCase("header1"), (Matcher)Matchers.is((Object)"value1"));
    }

    @Test
    void getHeaderValues() {
        Mockito.when((Object)this.sdkRequest.getHeaderValues("header1")).thenReturn(Arrays.asList("value1", "value2"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValues("header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValuesIgnoreCase("header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void containsHeader() {
        Mockito.when((Object)this.sdkRequest.containsHeader("header1")).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.requestWrapper.containsHeader("header1"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void getHeaders() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"header1", (Object)"value1");
        headers.put((Object)"header2", (Object)"value2");
        Mockito.when((Object)this.sdkRequest.getHeaders()).thenReturn((Object)headers);
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"header1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"header2", (Object)"value2")));
    }
}

