/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.support.internal.message.muletosdk;

import org.mule.sdk.api.http.domain.entity.HttpEntity;

import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;

public class HttpEntityWrapper implements HttpEntity {

  private final org.mule.runtime.http.api.domain.entity.HttpEntity muleEntity;

  public HttpEntityWrapper(org.mule.runtime.http.api.domain.entity.HttpEntity muleEntity) {
    this.muleEntity = muleEntity;
  }

  @Override
  public boolean isStreaming() {
    return muleEntity.isStreaming();
  }

  @Override
  public InputStream getContent() {
    return muleEntity.getContent();
  }

  @Override
  public byte[] getBytes() throws IOException {
    return muleEntity.getBytes();
  }

  @Override
  public OptionalLong getBytesLength() {
    return muleEntity.getBytesLength();
  }
}
