/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.mule.runtime.http.support.internal.client.TcpSocketPropertiesConfigurerToBuilder;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class TcpSocketPropertiesConfigurerToBuilderTestCase {
    private TcpSocketPropertiesConfigurerToBuilder configurer;
    private TcpClientSocketPropertiesBuilder actualBuilder;

    TcpSocketPropertiesConfigurerToBuilderTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.actualBuilder = TcpClientSocketProperties.builder();
        this.configurer = new TcpSocketPropertiesConfigurerToBuilder(this.actualBuilder);
    }

    @Test
    void sendBufferSize() {
        this.configurer.sendBufferSize(Integer.valueOf(123));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Object)123));
    }

    @Test
    void receiveBufferSize() {
        this.configurer.receiveBufferSize(Integer.valueOf(123));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Object)123));
    }

    @Test
    void clientTimeout() {
        this.configurer.clientTimeout(Integer.valueOf(123));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Object)123));
    }

    @Test
    void sendTcpNoDelay() {
        this.configurer.sendTcpNoDelay(Boolean.valueOf(true));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void linger() {
        this.configurer.linger(Integer.valueOf(12));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Object)12));
    }

    @Test
    void keepAlive() {
        this.configurer.keepAlive(Boolean.valueOf(false));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void connectionTimeout() {
        this.configurer.connectionTimeout(Integer.valueOf(123));
        TcpClientSocketProperties properties = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)properties.getConnectionTimeout(), (Matcher)Matchers.is((Object)123));
    }
}

