/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.runtime.http.support.internal.server.SseRequestContextWrapper;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseRequestContextWrapperTestCase {
    @Mock
    private SseRequestContext mockContext;
    private SseRequestContextWrapper ctxWrapper;

    SseRequestContextWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.ctxWrapper = new SseRequestContextWrapper(this.mockContext);
    }

    @Test
    void setClientId() {
        this.ctxWrapper.setClientId("clientId");
        ((SseRequestContext)Mockito.verify((Object)this.mockContext)).setClientId("clientId");
    }

    @Test
    void reject() {
        this.ctxWrapper.reject(507, "Whatever");
        ((SseRequestContext)Mockito.verify((Object)this.mockContext)).reject(507, "Whatever");
    }

    @Test
    void customizeResponse() {
        this.ctxWrapper.customizeResponse(c -> {});
        ((SseRequestContext)Mockito.verify((Object)this.mockContext)).customizeResponse((Consumer)ArgumentMatchers.any());
    }

    @Test
    void getRequestContext() {
        org.mule.runtime.http.api.domain.request.HttpRequestContext requestContext = (org.mule.runtime.http.api.domain.request.HttpRequestContext)Mockito.mock(org.mule.runtime.http.api.domain.request.HttpRequestContext.class);
        Mockito.when((Object)requestContext.getScheme()).thenReturn((Object)"test-scheme");
        Mockito.when((Object)this.mockContext.getRequestContext()).thenReturn((Object)requestContext);
        HttpRequestContext wrappedRequestContext = this.ctxWrapper.getRequestContext();
        MatcherAssert.assertThat((Object)wrappedRequestContext.getScheme(), (Matcher)Matchers.is((Object)"test-scheme"));
    }
}

