/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.support.internal.client.HttpAuthenticationConfigurerImpl;

@Feature(value="HTTP Forward Compatibility")
class HttpAuthenticationConfigurerImplTest {
    private final HttpAuthenticationConfigurerImpl configurer = new HttpAuthenticationConfigurerImpl();

    HttpAuthenticationConfigurerImplTest() {
    }

    @Test
    void testBasicAuthenticationWithPreemptive() {
        this.configurer.basic("user1", "pass1", true);
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auth.getType().name(), (Matcher)Matchers.is((Object)"BASIC"));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Matchers.is((Object)"user1"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Matchers.is((Object)"pass1"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testBasicAuthenticationWithoutPreemptive() {
        this.configurer.basic("user2", "pass2", false);
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auth.getType().name(), (Matcher)Matchers.is((Object)"BASIC"));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Matchers.is((Object)"user2"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Matchers.is((Object)"pass2"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testDigestAuthenticationWithPreemptive() {
        this.configurer.digest("user1", "pass1", true);
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auth.getType().name(), (Matcher)Matchers.is((Object)"DIGEST"));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Matchers.is((Object)"user1"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Matchers.is((Object)"pass1"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testDigestAuthenticationWithoutPreemptive() {
        this.configurer.digest("user2", "pass2", false);
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auth.getType().name(), (Matcher)Matchers.is((Object)"DIGEST"));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Matchers.is((Object)"user2"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Matchers.is((Object)"pass2"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testNtlmAuthenticationWithAllParameters() {
        this.configurer.ntlm("user1", "pass1", true, "domain", "workstation");
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.instanceOf(HttpAuthentication.HttpNtlmAuthentication.class));
        HttpAuthentication.HttpNtlmAuthentication ntlmAuth = (HttpAuthentication.HttpNtlmAuthentication)auth;
        MatcherAssert.assertThat((Object)ntlmAuth.getType().name(), (Matcher)Matchers.is((Object)"NTLM"));
        MatcherAssert.assertThat((Object)ntlmAuth.getUsername(), (Matcher)Matchers.is((Object)"user1"));
        MatcherAssert.assertThat((Object)ntlmAuth.getPassword(), (Matcher)Matchers.is((Object)"pass1"));
        MatcherAssert.assertThat((Object)ntlmAuth.getDomain(), (Matcher)Matchers.is((Object)"domain"));
        MatcherAssert.assertThat((Object)ntlmAuth.getWorkstation(), (Matcher)Matchers.is((Object)"workstation"));
        MatcherAssert.assertThat((Object)ntlmAuth.isPreemptive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testNtlmAuthenticationWithMinimalParameters() {
        this.configurer.ntlm("user2", "pass2", false, null, null);
        HttpAuthentication auth = this.configurer.build();
        MatcherAssert.assertThat((Object)auth, (Matcher)Matchers.instanceOf(HttpAuthentication.HttpNtlmAuthentication.class));
        HttpAuthentication.HttpNtlmAuthentication ntlmAuth = (HttpAuthentication.HttpNtlmAuthentication)auth;
        MatcherAssert.assertThat((Object)ntlmAuth.getType().name(), (Matcher)Matchers.is((Object)"NTLM"));
        MatcherAssert.assertThat((Object)ntlmAuth.getUsername(), (Matcher)Matchers.is((Object)"user2"));
        MatcherAssert.assertThat((Object)ntlmAuth.getPassword(), (Matcher)Matchers.is((Object)"pass2"));
        MatcherAssert.assertThat((Object)ntlmAuth.getDomain(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)ntlmAuth.getWorkstation(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)ntlmAuth.isPreemptive(), (Matcher)Matchers.is((Object)false));
    }
}

