/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.muletosdk;

import io.qameta.allure.Feature;
import java.net.URI;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.support.internal.message.muletosdk.HttpRequestWrapper;
import org.mule.sdk.api.http.domain.HttpProtocolVersion;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpRequestWrapperTestCase {
    @Mock
    private HttpRequest muleRequest;
    private HttpRequestWrapper requestWrapper;

    HttpRequestWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.requestWrapper = new HttpRequestWrapper(this.muleRequest);
    }

    @Test
    void getProtocolVersion() {
        Mockito.when((Object)this.muleRequest.getProtocol()).thenReturn((Object)HttpProtocol.HTTP_0_9);
        MatcherAssert.assertThat((Object)this.requestWrapper.getProtocolVersion(), (Matcher)Matchers.is((Object)HttpProtocolVersion.HTTP_0_9));
    }

    @Test
    void getPath() {
        Mockito.when((Object)this.muleRequest.getPath()).thenReturn((Object)"/path");
        MatcherAssert.assertThat((Object)this.requestWrapper.getPath(), (Matcher)Matchers.is((Object)"/path"));
    }

    @Test
    void getMethod() {
        Mockito.when((Object)this.muleRequest.getMethod()).thenReturn((Object)"GET");
        MatcherAssert.assertThat((Object)this.requestWrapper.getMethod(), (Matcher)Matchers.is((Object)"GET"));
    }

    @Test
    void getUri() {
        Mockito.when((Object)this.muleRequest.getUri()).thenReturn((Object)URI.create("/path"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getUri().getPath(), (Matcher)Matchers.is((Object)"/path"));
    }

    @Test
    void getQueryParams() {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"param1", (Object)"value1");
        queryParams.put((Object)"param2", (Object)"value2");
        Mockito.when((Object)this.muleRequest.getQueryParams()).thenReturn((Object)queryParams);
        MatcherAssert.assertThat((Object)this.requestWrapper.getQueryParams(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"param2", (Object)"value2")));
    }

    @Test
    void getEntity() {
        EmptyHttpEntity entity = new EmptyHttpEntity();
        Mockito.when((Object)this.muleRequest.getEntity()).thenReturn((Object)entity);
        MatcherAssert.assertThat((Object)this.requestWrapper.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.requestWrapper.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    void getHeaderNames() {
        Mockito.when((Object)this.muleRequest.getHeaderNames()).thenReturn(Arrays.asList("header1", "header2"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderNames(), (Matcher)Matchers.contains((Object[])new String[]{"header1", "header2"}));
    }

    @Test
    void getHeaderValue() {
        Mockito.when((Object)this.muleRequest.getHeaderValue("header1")).thenReturn((Object)"value1");
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValue("header1"), (Matcher)Matchers.is((Object)"value1"));
    }

    @Test
    void getHeaderValues() {
        Mockito.when((Object)this.muleRequest.getHeaderValues("header1")).thenReturn(Arrays.asList("value1", "value2"));
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaderValues("header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void containsHeader() {
        Mockito.when((Object)this.muleRequest.containsHeader("header1")).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.requestWrapper.containsHeader("header1"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void getHeaders() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"header1", (Object)"value1");
        headers.put((Object)"header2", (Object)"value2");
        Mockito.when((Object)this.muleRequest.getHeaders()).thenReturn((Object)headers);
        MatcherAssert.assertThat((Object)this.requestWrapper.getHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"header1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"header2", (Object)"value2")));
    }
}

