/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.sse.server.SseEndpointManager;
import org.mule.runtime.http.support.internal.server.HttpServerWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class HttpServerWrapperTestCase {
    @Mock
    private HttpServer delegateServer;
    @Mock
    private ServerAddress muleServerAddress;
    @Mock
    private RequestHandlerManager muleEndpointHandler;
    @Mock
    private SseEndpointManager muleSseEndpointManager;
    @Mock
    private org.mule.sdk.api.http.server.RequestHandler requestHandler;
    @Mock
    private TlsContextFactory tlsContextFactory;
    private HttpServerWrapper wrapper;

    HttpServerWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.delegateServer.getServerAddress()).thenReturn((Object)this.muleServerAddress);
        Mockito.when((Object)this.delegateServer.getProtocol()).thenReturn((Object)HttpConstants.Protocol.HTTP);
        this.wrapper = new HttpServerWrapper(this.delegateServer);
    }

    @Test
    void start() throws IOException, MuleException {
        this.wrapper.start();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).start();
    }

    @Test
    void stop() {
        this.wrapper.stop();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).stop();
    }

    @Test
    void dispose() {
        this.wrapper.dispose();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).dispose();
    }

    @Test
    void getServerAddress() {
        this.wrapper.getServerAddress();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).getServerAddress();
    }

    @Test
    void getProtocol() {
        this.wrapper.getProtocol();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).getProtocol();
    }

    @Test
    void isStopping() {
        Mockito.when((Object)this.delegateServer.isStopping()).thenReturn((Object)true);
        boolean stopping = this.wrapper.isStopping();
        MatcherAssert.assertThat((Object)stopping, (Matcher)Matchers.is((Object)true));
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).isStopping();
    }

    @Test
    void isStopped() {
        Mockito.when((Object)this.delegateServer.isStopped()).thenReturn((Object)false);
        boolean stopped = this.wrapper.isStopped();
        MatcherAssert.assertThat((Object)stopped, (Matcher)Matchers.is((Object)false));
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).isStopped();
    }

    @Test
    void enableTls() {
        this.wrapper.enableTls(this.tlsContextFactory);
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).enableTls(this.tlsContextFactory);
    }

    @Test
    void disableTls() {
        this.wrapper.disableTls();
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).disableTls();
    }

    @Test
    void addRequestHandlerWithMethods() {
        Mockito.when((Object)this.delegateServer.addRequestHandler(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyString(), (RequestHandler)ArgumentMatchers.any())).thenReturn((Object)this.muleEndpointHandler);
        this.wrapper.addRequestHandler(Arrays.asList("GET", "POST"), "/test", this.requestHandler);
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).addRequestHandler(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyString(), (RequestHandler)ArgumentMatchers.any());
    }

    @Test
    void addRequestHandlerWithoutMethods() {
        Mockito.when((Object)this.delegateServer.addRequestHandler(ArgumentMatchers.anyString(), (RequestHandler)ArgumentMatchers.any())).thenReturn((Object)this.muleEndpointHandler);
        this.wrapper.addRequestHandler("/test", this.requestHandler);
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).addRequestHandler(ArgumentMatchers.anyString(), (RequestHandler)ArgumentMatchers.any());
    }

    @Test
    void testSse() {
        Mockito.when((Object)this.delegateServer.sse(ArgumentMatchers.anyString(), (Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenReturn((Object)this.muleSseEndpointManager);
        this.wrapper.sse("/sse", context -> {}, client -> {});
        ((HttpServer)Mockito.verify((Object)this.delegateServer)).sse(ArgumentMatchers.anyString(), (Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
    }
}

