/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.muletosdk;

import io.qameta.allure.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.support.internal.message.muletosdk.HttpEntityWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class HttpEntityWrapperTestCase {
    @Mock
    private HttpEntity mockMuleEntity;
    @Mock
    private HttpPart mockMulePart;
    private HttpEntityWrapper wrapper;

    HttpEntityWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.wrapper = new HttpEntityWrapper(this.mockMuleEntity);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void isStreaming(boolean streaming) {
        Mockito.when((Object)this.mockMuleEntity.isStreaming()).thenReturn((Object)streaming);
        boolean result = this.wrapper.isStreaming();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)streaming));
        ((HttpEntity)Mockito.verify((Object)this.mockMuleEntity)).isStreaming();
    }

    @Test
    void getContentDoesNotCopyTheStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test content".getBytes());
        Mockito.when((Object)this.mockMuleEntity.getContent()).thenReturn((Object)inputStream);
        InputStream result = this.wrapper.getContent();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)inputStream)));
        ((HttpEntity)Mockito.verify((Object)this.mockMuleEntity)).getContent();
    }

    @Test
    void getBytes() throws IOException {
        byte[] bytes = "test content".getBytes();
        Mockito.when((Object)this.mockMuleEntity.getBytes()).thenReturn((Object)bytes);
        byte[] result = this.wrapper.getBytes();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)bytes));
        ((HttpEntity)Mockito.verify((Object)this.mockMuleEntity)).getBytes();
    }

    @ParameterizedTest
    @ValueSource(longs={100L, 200L})
    void getBytesLength(long length) {
        OptionalLong optionalLen = OptionalLong.of(length);
        Mockito.when((Object)this.mockMuleEntity.getBytesLength()).thenReturn((Object)optionalLen);
        OptionalLong result = this.wrapper.getBytesLength();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)optionalLen));
        ((HttpEntity)Mockito.verify((Object)this.mockMuleEntity)).getBytesLength();
    }

    @Test
    void getBytesLengthEmpty() {
        OptionalLong optionalLen = OptionalLong.empty();
        Mockito.when((Object)this.mockMuleEntity.getBytesLength()).thenReturn((Object)optionalLen);
        OptionalLong result = this.wrapper.getBytesLength();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)optionalLen));
        ((HttpEntity)Mockito.verify((Object)this.mockMuleEntity)).getBytesLength();
    }
}

