/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.support.internal.server.ServerAddressWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class ServerAddressWrapperTestCase {
    @Mock
    private ServerAddress mockAddress;
    private ServerAddressWrapper addressWrapper;

    ServerAddressWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.addressWrapper = new ServerAddressWrapper(this.mockAddress);
    }

    @Test
    void getPort() {
        Mockito.when((Object)this.mockAddress.getPort()).thenReturn((Object)12345);
        MatcherAssert.assertThat((Object)this.addressWrapper.getPort(), (Matcher)Matchers.is((Object)12345));
    }

    @Test
    void getIp() {
        Mockito.when((Object)this.mockAddress.getIp()).thenReturn((Object)"1.2.3.4");
        MatcherAssert.assertThat((Object)this.addressWrapper.getIp(), (Matcher)Matchers.is((Object)"1.2.3.4"));
    }

    @Test
    void getAddress() throws UnknownHostException {
        InetAddress address = InetAddress.getByName("1.2.3.4");
        Mockito.when((Object)this.mockAddress.getAddress()).thenReturn((Object)address);
        MatcherAssert.assertThat((Object)this.addressWrapper.getAddress(), (Matcher)Matchers.is((Object)address));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void overlaps(boolean shouldOverlap) {
        ServerAddress anotherAddress = (ServerAddress)Mockito.mock(ServerAddress.class);
        ServerAddressWrapper anotherWrapper = new ServerAddressWrapper(anotherAddress);
        Mockito.when((Object)this.mockAddress.overlaps(anotherAddress)).thenReturn((Object)shouldOverlap);
        MatcherAssert.assertThat((Object)this.addressWrapper.overlaps((org.mule.sdk.api.http.server.ServerAddress)anotherWrapper), (Matcher)Matchers.is((Object)shouldOverlap));
    }
}

