/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.support.internal.protocol;

import org.mule.sdk.api.http.protocol.Http2ProtocolConfigurer;

public class Http2ProtocolConfigurerImpl implements Http2ProtocolConfigurer {

  private final org.mule.runtime.http.api.Http2ProtocolConfig config;

  public Http2ProtocolConfigurerImpl(org.mule.runtime.http.api.Http2ProtocolConfig config) {
    this.config = config;
  }

  @Override
  public Http2ProtocolConfigurer setEnabled(boolean enabled) {
    config.setEnabled(enabled);
    return this;
  }

  @Override
  public Http2ProtocolConfigurer setHeaderTableSize(Long headerTableSize) {
    config.setHeaderTableSize(headerTableSize);
    return this;
  }

  @Override
  public Http2ProtocolConfigurer setInitialWindowSize(Integer initialWindowSize) {
    config.setInitialWindowSize(initialWindowSize);
    return this;
  }

  @Override
  public Http2ProtocolConfigurer setMaxConcurrentStreams(Long maxConcurrentStreams) {
    config.setMaxConcurrentStreams(maxConcurrentStreams);
    return this;
  }

  @Override
  public Http2ProtocolConfigurer setMaxFrameSize(Integer maxFrameSize) {
    config.setMaxFrameSize(maxFrameSize);
    return this;
  }

  @Override
  public Http2ProtocolConfigurer setMaxHeaderListSize(Long maxHeaderListSize) {
    config.setMaxHeaderListSize(maxHeaderListSize);
    return this;
  }
}
