/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.support.internal.server.SseClientWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseClientWrapperTestCase {
    @Mock
    private SseClient mockClient;
    private SseClientWrapper clientWrapper;

    SseClientWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.clientWrapper = new SseClientWrapper(this.mockClient);
    }

    @Test
    void sendEvent() throws IOException {
        this.clientWrapper.sendEvent("data");
        ((SseClient)Mockito.verify((Object)this.mockClient)).sendEvent("data");
        Mockito.reset((Object[])new SseClient[]{this.mockClient});
        this.clientWrapper.sendEvent("name", "data");
        ((SseClient)Mockito.verify((Object)this.mockClient)).sendEvent("name", "data");
        Mockito.reset((Object[])new SseClient[]{this.mockClient});
        this.clientWrapper.sendEvent("name", "data", "id");
        ((SseClient)Mockito.verify((Object)this.mockClient)).sendEvent("name", "data", "id");
        Mockito.reset((Object[])new SseClient[]{this.mockClient});
        this.clientWrapper.sendEvent("name", "data", "id", Long.valueOf(123L));
        ((SseClient)Mockito.verify((Object)this.mockClient)).sendEvent("name", "data", "id", Long.valueOf(123L));
    }

    @Test
    void sendComment() {
        this.clientWrapper.sendComment("comment");
        ((SseClient)Mockito.verify((Object)this.mockClient)).sendComment("comment");
    }

    @Test
    void onClose() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.clientWrapper.onClose(callback);
        ((SseClient)Mockito.verify((Object)this.mockClient)).onClose(callback);
    }

    @Test
    void getClientId() {
        Mockito.when((Object)this.mockClient.getClientId()).thenReturn((Object)"id");
        MatcherAssert.assertThat((Object)this.clientWrapper.getClientId(), (Matcher)Matchers.is((Object)"id"));
    }

    @Test
    void getRemoteAddress() {
        InetSocketAddress remoteAddress = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)this.mockClient.getRemoteAddress()).thenReturn((Object)remoteAddress);
        MatcherAssert.assertThat((Object)this.clientWrapper.getRemoteAddress(), (Matcher)Matchers.is((Object)remoteAddress));
    }

    @Test
    void close() throws IOException {
        this.clientWrapper.close();
        ((SseClient)Mockito.verify((Object)this.mockClient)).close();
    }
}

