/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.client.SseFailureContext;
import org.mule.runtime.http.support.internal.client.SseFailureContextWrapper;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseFailureContextWrapperTestCase {
    @Mock
    private SseFailureContext actualContext;
    @Mock
    private org.mule.runtime.http.api.domain.message.response.HttpResponse muleResponse;
    private SseFailureContextWrapper contextWrapper;

    SseFailureContextWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.contextWrapper = new SseFailureContextWrapper(this.actualContext);
    }

    @Test
    void delegateError() {
        RuntimeException error = new RuntimeException("Test error");
        Mockito.when((Object)this.actualContext.error()).thenReturn((Object)error);
        Throwable result = this.contextWrapper.error();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)error));
    }

    @Test
    void errorReturnsNull() {
        Mockito.when((Object)this.actualContext.error()).thenReturn(null);
        Throwable result = this.contextWrapper.error();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)null));
    }

    @Test
    void delegateResponse() {
        int mockStatusCode = 207;
        Mockito.when((Object)this.muleResponse.getStatusCode()).thenReturn((Object)mockStatusCode);
        Mockito.when((Object)this.actualContext.response()).thenReturn((Object)this.muleResponse);
        HttpResponse responseWrapper = this.contextWrapper.response();
        MatcherAssert.assertThat((Object)responseWrapper.getStatusCode(), (Matcher)Matchers.is((Object)mockStatusCode));
    }

    @Test
    void delegateStopRetrying() {
        this.contextWrapper.stopRetrying();
        ((SseFailureContext)Mockito.verify((Object)this.actualContext)).stopRetrying();
    }
}

