/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.runtime.http.api.sse.client.SseSource;
import org.mule.runtime.http.support.internal.client.SseSourceWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseSourceWrapperTestCase {
    private SseSourceWrapper sseSourceWrapper;
    @Mock
    private SseSource muleSseSource;

    SseSourceWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.sseSourceWrapper = new SseSourceWrapper(this.muleSseSource);
    }

    @Test
    void delegatesOpenToSseSource() {
        this.sseSourceWrapper.open();
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).open();
    }

    @Test
    void delegatesReadyState() {
        Mockito.when((Object)this.muleSseSource.getReadyState()).thenReturn((Object)1);
        MatcherAssert.assertThat((Object)this.sseSourceWrapper.getReadyState(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void delegatesRegister() {
        org.mule.sdk.api.http.sse.client.SseListener listener = (org.mule.sdk.api.http.sse.client.SseListener)Mockito.mock(org.mule.sdk.api.http.sse.client.SseListener.class);
        this.sseSourceWrapper.register(listener);
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).register((SseListener)ArgumentMatchers.any(SseListener.class));
        this.sseSourceWrapper.register("topic", listener);
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).register((String)ArgumentMatchers.eq((Object)"topic"), (SseListener)ArgumentMatchers.any(SseListener.class));
    }

    @Test
    void delegatesConnectionFailureCallback() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.sseSourceWrapper.doOnConnectionFailure(callback);
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).doOnConnectionFailure((Consumer)ArgumentMatchers.any(Consumer.class));
    }

    @Test
    void delegatesCloseToSseSource() {
        this.sseSourceWrapper.close();
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).close();
    }
}

