/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.support.internal.server.RequestHandlerWrapper;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;
import org.mule.sdk.api.http.server.RequestHandler;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class RequestHandlerWrapperTestCase {
    @Mock
    private RequestHandler mockHandler;
    private RequestHandlerWrapper handlerWrapper;

    RequestHandlerWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.handlerWrapper = new RequestHandlerWrapper(this.mockHandler);
    }

    @Test
    void handleRequest() {
        org.mule.runtime.http.api.domain.request.HttpRequestContext requestContext = (org.mule.runtime.http.api.domain.request.HttpRequestContext)Mockito.mock(org.mule.runtime.http.api.domain.request.HttpRequestContext.class);
        HttpResponseReadyCallback responseCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        this.handlerWrapper.handleRequest(requestContext, responseCallback);
        ((RequestHandler)Mockito.verify((Object)this.mockHandler)).handleRequest((HttpRequestContext)ArgumentMatchers.any(), (org.mule.sdk.api.http.server.async.HttpResponseReadyCallback)ArgumentMatchers.any());
    }

    @Test
    void getContextClassLoader() {
        ClassLoader classLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)this.mockHandler.getContextClassLoader()).thenReturn((Object)classLoader);
        ClassLoader got = this.handlerWrapper.getContextClassLoader();
        MatcherAssert.assertThat((Object)got, (Matcher)Matchers.is((Object)classLoader));
    }
}

