/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.support.internal.server.ClientConnectionWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class ClientConnectionWrapperTestCase {
    @Mock
    private ClientConnection muleConnection;
    private ClientConnectionWrapper connectionWrapper;

    ClientConnectionWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.connectionWrapper = new ClientConnectionWrapper(this.muleConnection);
    }

    @Test
    void getRemoteHostAddress() {
        InetSocketAddress socketAddress = new InetSocketAddress("127.0.0.1", 8080);
        Mockito.when((Object)this.muleConnection.getRemoteHostAddress()).thenReturn((Object)socketAddress);
        MatcherAssert.assertThat((Object)this.muleConnection.getRemoteHostAddress(), (Matcher)Matchers.is((Object)socketAddress));
    }

    @Test
    void getConnection() {
        Certificate cert = (Certificate)Mockito.mock(Certificate.class);
        Mockito.when((Object)this.muleConnection.getClientCertificate()).thenReturn((Object)cert);
        MatcherAssert.assertThat((Object)this.connectionWrapper.getClientCertificate(), (Matcher)Matchers.is((Object)cert));
    }
}

