/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.runtime.http.support.internal.message.HttpRequestBuilderWrapper;
import org.mule.sdk.api.http.HttpConstants;
import org.mule.sdk.api.http.domain.HttpProtocolVersion;
import org.mule.sdk.api.http.domain.entity.HttpEntity;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;
import org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder;

@Feature(value="HTTP Forward Compatibility")
class HttpRequestBuilderWrapperTestCase {
    private static final String TEST_URI = "https://example.com";
    private HttpRequestBuilderWrapper builderWrapper;

    HttpRequestBuilderWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.builderWrapper = new HttpRequestBuilderWrapper();
    }

    @Test
    void uriWithString() {
        this.builderWrapper.uri(TEST_URI);
        MatcherAssert.assertThat((Object)this.builderWrapper.getUri().toString(), (Matcher)Matchers.is((Object)TEST_URI));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getUri().toString(), (Matcher)Matchers.is((Object)TEST_URI));
    }

    @Test
    void uriWithURI() {
        this.builderWrapper.uri(URI.create(TEST_URI));
        MatcherAssert.assertThat((Object)this.builderWrapper.getUri().toString(), (Matcher)Matchers.is((Object)TEST_URI));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getUri().toString(), (Matcher)Matchers.is((Object)TEST_URI));
    }

    @Test
    void uriIsMandatory() {
        NullPointerException error = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((HttpRequestBuilderWrapper)this.builderWrapper).build());
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)"URI must be specified to create an HTTP request"));
    }

    @Test
    void protocol() {
        this.builderWrapper.uri(TEST_URI).protocol(HttpProtocolVersion.HTTP_1_1);
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getProtocolVersion(), (Matcher)Matchers.is((Object)HttpProtocolVersion.HTTP_1_1));
    }

    @Test
    void methodWithString() {
        String method = "POST";
        this.builderWrapper.uri(TEST_URI).method(method);
        MatcherAssert.assertThat((Object)this.builderWrapper.getMethod(), (Matcher)Matchers.is((Object)method));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)method));
    }

    @Test
    void methodWithEnum() {
        this.builderWrapper.uri(TEST_URI).method(HttpConstants.Method.HEAD);
        MatcherAssert.assertThat((Object)this.builderWrapper.getMethod(), (Matcher)Matchers.is((Object)"HEAD"));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"HEAD"));
    }

    @Test
    void addQueryParam() {
        MultiMap basic = new MultiMap();
        basic.put((Object)"key1", (Object)"value1");
        this.builderWrapper.uri(TEST_URI).queryParams(basic).addQueryParam("key2", "value2");
        MatcherAssert.assertThat((Object)this.builderWrapper.getQueryParams(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value2")));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getQueryParams(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value2")));
    }

    @Test
    void entity() throws IOException {
        HttpEntity entity = new HttpEntityFactoryImpl().from("test content", StandardCharsets.UTF_8);
        this.builderWrapper.uri(TEST_URI).entity(entity);
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getEntity().getBytes(), (Matcher)Matchers.is((Object)"test content".getBytes()));
    }

    @Test
    void addHeader() {
        this.builderWrapper.uri(TEST_URI).addHeader("key", "value");
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaderValue("key").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.builderWrapper.getHeaderValue("key").get()), (Matcher)Matchers.is((Object)"value"));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getHeaderValue("key"), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    void addHeaders() {
        this.builderWrapper.uri(TEST_URI).addHeaders("header", Arrays.asList("value1", "value2"));
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaderValues("header"), (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getHeaderValues("header"), (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void removeHeader() {
        ((HttpRequestBuilder)this.builderWrapper.uri(TEST_URI).addHeader("test-header", "test-value")).removeHeader("test-header");
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.containsHeader("test-header"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void headers() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"key1", (Object)"value1");
        this.builderWrapper.uri(TEST_URI).headers(headers);
        MatcherAssert.assertThat((Object)this.builderWrapper.getHeaders().getAll((Object)"key1"), (Matcher)Matchers.hasItem((Object)"value1"));
        HttpRequest request = this.builderWrapper.build();
        MatcherAssert.assertThat((Object)request.getHeaders().getAll((Object)"key1"), (Matcher)Matchers.hasItem((Object)"value1"));
    }
}

