/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.support.internal.protocol;

import org.mule.sdk.api.http.protocol.Http1ProtocolConfigurer;

public class Http1ProtocolConfigurerImpl implements Http1ProtocolConfigurer {

  private final org.mule.runtime.http.api.Http1ProtocolConfig config;

  public Http1ProtocolConfigurerImpl(org.mule.runtime.http.api.Http1ProtocolConfig config) {
    this.config = config;
  }

  @Override
  public Http1ProtocolConfigurer setEnabled(boolean enabled) {
    config.setEnabled(enabled);
    return this;
  }
}
