/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message.sdktomule;

import io.qameta.allure.Feature;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpResponseWrapper;
import org.mule.sdk.api.http.domain.entity.HttpEntity;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpResponseWrapperTestCase {
    @Mock
    private HttpResponse sdkResponse;
    private HttpResponseWrapper responseWrapper;

    HttpResponseWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.responseWrapper = new HttpResponseWrapper(this.sdkResponse);
    }

    @Test
    void getStatusCode() {
        Mockito.when((Object)this.sdkResponse.getStatusCode()).thenReturn((Object)207);
        MatcherAssert.assertThat((Object)this.responseWrapper.getStatusCode(), (Matcher)Matchers.is((Object)207));
    }

    @Test
    void getReasonPhrase() {
        Mockito.when((Object)this.sdkResponse.getReasonPhrase()).thenReturn((Object)"Hello");
        MatcherAssert.assertThat((Object)this.responseWrapper.getReasonPhrase(), (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    void getEntity() {
        HttpEntity entity = new HttpEntityFactoryImpl().emptyEntity();
        Mockito.when((Object)this.sdkResponse.getEntity()).thenReturn((Object)entity);
        MatcherAssert.assertThat((Object)this.responseWrapper.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.responseWrapper.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    void getHeaderNames() {
        Mockito.when((Object)this.sdkResponse.getHeaderNames()).thenReturn(Arrays.asList("header1", "header2"));
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaderNames(), (Matcher)Matchers.contains((Object[])new String[]{"header1", "header2"}));
    }

    @Test
    void containsHeader() {
        Mockito.when((Object)this.sdkResponse.getHeaderValue("header1")).thenReturn((Object)"Present!");
        MatcherAssert.assertThat((Object)this.responseWrapper.containsHeader("header1"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void getHeaderValue() {
        Mockito.when((Object)this.sdkResponse.getHeaderValue("header1")).thenReturn((Object)"value1");
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaderValue("header1"), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaderValueIgnoreCase("header1"), (Matcher)Matchers.is((Object)"value1"));
    }

    @Test
    void getHeaderValues() {
        Mockito.when((Object)this.sdkResponse.getHeaderValues("header1")).thenReturn(Arrays.asList("value1", "value2"));
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaderValues("header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaderValuesIgnoreCase("header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void getHeaders() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"header1", (Object)"value1");
        headers.put((Object)"header2", (Object)"value2");
        Mockito.when((Object)this.sdkResponse.getHeaders()).thenReturn((Object)headers);
        MatcherAssert.assertThat((Object)this.responseWrapper.getHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"header1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"header2", (Object)"value2")));
    }
}

