/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.support.internal.client.ProxyConfigImpl;

@Feature(value="HTTP Forward Compatibility")
class ProxyConfigImplTestCase {
    private static final String PROXY_HOST = "localhost";
    private static final int PROXY_PORT = 7777;
    private static final String NON_PROXY_HOST = "non-proxy-host";
    private static final String PROXY_USERNAME = "Quiroga";
    private static final String PROXY_PASSWORD = "Capiangos";
    private static final String PROXY_DOMAIN = "Punz\u00c3\u00b3";
    private final ProxyConfigImpl configurer = new ProxyConfigImpl();

    ProxyConfigImplTestCase() {
    }

    @Test
    void proxyWithBasicAuth() {
        this.configurer.host(PROXY_HOST).port(7777).nonProxyHosts(NON_PROXY_HOST).auth(auth -> auth.basic(PROXY_USERNAME, PROXY_PASSWORD, false));
        ProxyConfig proxyConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)proxyConfig.getHost(), (Matcher)Matchers.is((Object)PROXY_HOST));
        MatcherAssert.assertThat((Object)proxyConfig.getPort(), (Matcher)Matchers.is((Object)7777));
        MatcherAssert.assertThat((Object)proxyConfig.getNonProxyHosts(), (Matcher)Matchers.is((Object)NON_PROXY_HOST));
        MatcherAssert.assertThat((Object)proxyConfig.getUsername(), (Matcher)Matchers.is((Object)PROXY_USERNAME));
        MatcherAssert.assertThat((Object)proxyConfig.getPassword(), (Matcher)Matchers.is((Object)PROXY_PASSWORD));
    }

    @Test
    void proxyWithBasicAuthHasToBeNonPreemptive() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.configurer.auth(auth -> auth.basic(PROXY_USERNAME, PROXY_PASSWORD, true)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Preemptive basic authentication is not supported for proxy"));
    }

    @Test
    void digestIsNotAllowedForProxy() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.configurer.auth(auth -> auth.digest(PROXY_USERNAME, PROXY_PASSWORD, false)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Digest authentication is not supported for proxy"));
    }

    @Test
    void proxyWithNTLMAuth() {
        this.configurer.host(PROXY_HOST).port(7777).nonProxyHosts(NON_PROXY_HOST).auth(auth -> auth.ntlm(PROXY_USERNAME, PROXY_PASSWORD, false, PROXY_DOMAIN, null));
        ProxyConfig proxyConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)proxyConfig, (Matcher)Matchers.instanceOf(ProxyConfig.NtlmProxyConfig.class));
        ProxyConfig.NtlmProxyConfig ntlmProxyConfig = (ProxyConfig.NtlmProxyConfig)proxyConfig;
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getHost(), (Matcher)Matchers.is((Object)PROXY_HOST));
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getPort(), (Matcher)Matchers.is((Object)7777));
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getNonProxyHosts(), (Matcher)Matchers.is((Object)NON_PROXY_HOST));
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getUsername(), (Matcher)Matchers.is((Object)PROXY_USERNAME));
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getPassword(), (Matcher)Matchers.is((Object)PROXY_PASSWORD));
        MatcherAssert.assertThat((Object)ntlmProxyConfig.getNtlmDomain(), (Matcher)Matchers.is((Object)PROXY_DOMAIN));
    }

    @Test
    void ntlmProxyCannotBePreemptiveNorHaveWorkstation() {
        IllegalArgumentException errorOnPreemptive = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.configurer.auth(auth -> auth.ntlm(PROXY_USERNAME, PROXY_PASSWORD, true, PROXY_DOMAIN, null)));
        MatcherAssert.assertThat((Object)errorOnPreemptive.getMessage(), (Matcher)Matchers.is((Object)"Preemptive NTLM authentication is not supported for proxy"));
        IllegalArgumentException errorOnWorkstation = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.configurer.auth(auth -> auth.ntlm(PROXY_USERNAME, PROXY_PASSWORD, false, PROXY_DOMAIN, "Wrongstation")));
        MatcherAssert.assertThat((Object)errorOnWorkstation.getMessage(), (Matcher)Matchers.is((Object)"NTLM workstation can't be configured for proxy"));
    }
}

