/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.support.internal.server.HttpRequestContextWrapper;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class HttpRequestContextWrapperTestCase {
    @Mock
    private HttpRequestContext mockContext;
    private HttpRequestContextWrapper ctxWrapper;

    HttpRequestContextWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.ctxWrapper = new HttpRequestContextWrapper(this.mockContext);
    }

    @Test
    void getScheme() {
        Mockito.when((Object)this.mockContext.getScheme()).thenReturn((Object)"https");
        MatcherAssert.assertThat((Object)this.ctxWrapper.getScheme(), (Matcher)Matchers.is((Object)"https"));
    }

    @Test
    void getRequest() {
        HttpRequest request = HttpRequest.builder().uri("/test").build();
        Mockito.when((Object)this.mockContext.getRequest()).thenReturn((Object)request);
        MatcherAssert.assertThat((Object)this.ctxWrapper.getRequest().getUri().getPath(), (Matcher)Matchers.is((Object)"/test"));
    }

    @Test
    void getServerConnection() {
        this.ctxWrapper.getServerConnection();
        ((HttpRequestContext)Mockito.verify((Object)this.mockContext)).getServerConnection();
    }

    @Test
    void getClientConnection() {
        this.ctxWrapper.getClientConnection();
        ((HttpRequestContext)Mockito.verify((Object)this.mockContext)).getClientConnection();
    }
}

